/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.vendor.checker.services;

import com.suncode.plugin.vendor.checker.entity.VendorCheckerEntity;
import com.suncode.plugin.vendor.checker.entity.VendorChecker_Dao;
import com.suncode.plugin.vendor.checker.enums.ApiMethod;
import com.suncode.plugin.vendor.checker.schemas.ParamData;
import com.suncode.plugin.vendor.checker.services.VendorCheckerService;
import com.suncode.pwfl.support.hibernate.criterion.HibernateCriteria;
import com.suncode.pwfl.support.hibernate.criterion.Restrictions;
import com.suncode.pwfl.util.EditableServiceImpl;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class VendorCheckerServiceImpl
extends EditableServiceImpl<VendorCheckerEntity, Long, VendorChecker_Dao>
implements VendorCheckerService {
    private static final Logger log = LoggerFactory.getLogger(VendorCheckerServiceImpl.class);

    @Autowired
    public void setDao(VendorChecker_Dao dao) {
        this.dao = dao;
    }

    private VendorCheckerEntity findOne(String requestId) {
        HibernateCriteria vendorCheckerCriteria = HibernateCriteria.forClass(VendorCheckerEntity.class);
        vendorCheckerCriteria.add(Restrictions.eq((String)"requestid", (Object)requestId));
        return (VendorCheckerEntity)((VendorChecker_Dao)this.dao).findOne(vendorCheckerCriteria);
    }

    @Override
    public Long saveEntity(String status, String requestId, ParamData paramData, String processId, ApiMethod apiMethod) {
        Long id = -1L;
        VendorCheckerEntity entityFinded = this.findOne(requestId);
        if (entityFinded == null) {
            VendorCheckerEntity vendorEntity = this.buildVendorEntity(status, requestId, paramData, processId, apiMethod);
            log.debug("Save new");
            log.debug(vendorEntity.toString());
            id = (Long)((VendorChecker_Dao)this.dao).save(vendorEntity);
        } else {
            log.debug("Don't save. Data with requestID:\t" + requestId + " already exist");
            log.debug(entityFinded.toString());
            id = entityFinded.getId();
        }
        log.debug("pm_vendor_checker id:\t" + id);
        return id;
    }

    private VendorCheckerEntity buildVendorEntity(String status, String requestId, ParamData paramData, String processId, ApiMethod apiMethod) {
        VendorCheckerEntity vendorEntity = new VendorCheckerEntity();
        vendorEntity.setStatus(status);
        vendorEntity.setRequestid(requestId);
        vendorEntity.setIban(paramData.getNrb());
        vendorEntity.setDate(paramData.getDate());
        vendorEntity.setNip(paramData.getNip());
        vendorEntity.setRagon("");
        vendorEntity.setExecuteDate(DateTime.now().toLocalDate());
        vendorEntity.setMethod(apiMethod.getMethodName());
        vendorEntity.setProcessId(processId);
        return vendorEntity;
    }
}

