/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.vendor.checker.services;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonToken;
import com.suncode.dbexplorer.DatabaseExplorer;
import com.suncode.dbexplorer.alias.Alias;
import com.suncode.dbexplorer.database.Database;
import com.suncode.plugin.vendor.checker.services.FlatFileMaskService;
import com.suncode.plugin.vendor.checker.services.JsonParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JsonParserImpl
implements JsonParser {
    private static final int MAX_DATA_PER_TRANSACTION = 100000;
    private static final String MASK = "maski";
    private static final String HASH_RELEASE = "skrotyPodatnikowZwolnionych";
    private static final String HASH_ACTIVE = "skrotyPodatnikowCzynnych";
    private static final String GENERETED_DATE = "dataGenerowaniaDanych";
    private static final String HEADER = "naglowek";
    @Autowired
    private FlatFileMaskService maskService;
    @Autowired
    private DatabaseExplorer databaseExplorer;
    private DateTimeFormatter dtFormatter = DateTimeFormat.forPattern((String)"yyyyMMdd");

    @Override
    public Long parseAndSave2DB(File file) throws IOException {
        ArrayList<String> data2SaveDB = new ArrayList<String>();
        JsonFactory jsonfactory = new JsonFactory();
        Long count = 0L;
        try (FileInputStream is = new FileInputStream(file);){
            com.fasterxml.jackson.core.JsonParser jsonParser = jsonfactory.createParser((InputStream)is);
            JsonToken jsonToken = jsonParser.nextToken();
            Long generateDate = null;
            while (jsonToken != JsonToken.END_OBJECT) {
                Long l;
                String fieldname = jsonParser.getCurrentName();
                if (fieldname != null && fieldname.equals(HEADER)) {
                    jsonToken = jsonParser.nextToken();
                    while (jsonToken != JsonToken.END_OBJECT) {
                        jsonToken = jsonParser.nextToken();
                        fieldname = jsonParser.getCurrentName();
                        if (fieldname == null || !fieldname.equals(GENERETED_DATE)) continue;
                        jsonToken = jsonParser.nextToken();
                        generateDate = LocalDate.parse((String)jsonParser.getText(), (DateTimeFormatter)this.dtFormatter);
                    }
                }
                if (fieldname != null && (fieldname.equals(HASH_ACTIVE) || fieldname.equals(HASH_RELEASE))) {
                    Long date;
                    jsonToken = jsonParser.nextToken();
                    while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                        data2SaveDB.add(jsonParser.getText());
                        if (data2SaveDB.size() >= 100000) {
                            date = generateDate;
                            this.executeSqlInsertRecords((LocalDate)date, data2SaveDB);
                        }
                        date = count;
                        l = count = Long.valueOf(count + 1L);
                    }
                    if (data2SaveDB.size() > 0) {
                        date = generateDate;
                        this.executeSqlInsertRecords((LocalDate)date, (List<String>)data2SaveDB);
                    }
                }
                if (fieldname != null && fieldname.equals(MASK)) {
                    jsonToken = jsonParser.nextToken();
                    data2SaveDB.clear();
                    while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                        data2SaveDB.add(jsonParser.getText());
                        if (data2SaveDB.size() >= 100000) {
                            data2SaveDB.stream().forEach(mask -> this.maskService.save((String)mask));
                            data2SaveDB.clear();
                        }
                        Long l2 = count;
                        l = count = Long.valueOf(count + 1L);
                    }
                    if (data2SaveDB.size() > 0) {
                        data2SaveDB.stream().forEach(mask -> this.maskService.save((String)mask));
                        data2SaveDB.clear();
                    }
                }
                jsonToken = jsonParser.nextToken();
            }
        }
        return count;
    }

    public void executeSqlInsertRecords(LocalDate localDate, List<String> data2SaveDB) {
        Date date = new Date(localDate.toDateTimeAtStartOfDay().getMillis());
        Database database = this.databaseExplorer.get(this.resolveDatabaseAliasName());
        database.withinSession(session -> {
            String insertQuery = "INSERT INTO pm_vendor_flatfile_hash (hash, file_date) VALUES (?, ?)";
            Connection connection = session.getConnection();
            try (PreparedStatement statement = connection.prepareStatement(insertQuery);){
                for (String hash : data2SaveDB) {
                    statement.setString(1, hash);
                    statement.setDate(2, date);
                    statement.addBatch();
                }
                statement.executeBatch();
                data2SaveDB.clear();
            }
            return true;
        });
    }

    private String resolveDatabaseAliasName() {
        if (this.databaseExplorer.getAliasService().getAliases().stream().noneMatch(Alias::getIsSystemAlias) && Objects.isNull(this.databaseExplorer.getAliasService().getAlias(Alias.SYSTEM_ALIAS_NAME))) {
            return this.databaseExplorer.getAliasService().addSystemAlias().getName();
        }
        return Alias.SYSTEM_ALIAS_NAME;
    }
}

