/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.vendor.checker.services;

import com.suncode.plugin.vendor.checker.entity.FlatFileIndexEntity;
import com.suncode.plugin.vendor.checker.entity.FlatFileIndex_Dao;
import com.suncode.plugin.vendor.checker.services.FlatFileIndexService;
import com.suncode.pwfl.support.hibernate.criterion.HibernateCriteria;
import com.suncode.pwfl.support.hibernate.criterion.Restrictions;
import com.suncode.pwfl.util.EditableServiceImpl;
import java.sql.Date;
import java.util.List;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class FlatFileindexServiceImpl
extends EditableServiceImpl<FlatFileIndexEntity, Long, FlatFileIndex_Dao>
implements FlatFileIndexService {
    private static final Logger log = LoggerFactory.getLogger(FlatFileindexServiceImpl.class);

    @Autowired
    public void setDao(FlatFileIndex_Dao dao) {
        this.dao = dao;
    }

    @Override
    public void save(LocalDate date) {
        FlatFileIndexEntity entity = new FlatFileIndexEntity();
        entity.setDate(date);
        ((FlatFileIndex_Dao)this.dao).save(entity);
    }

    @Override
    public Boolean checkExist(LocalDate jodaDate) {
        return this.findOneOfDate(jodaDate) != null;
    }

    private FlatFileIndexEntity findOneOfDate(LocalDate jodaDate) {
        HibernateCriteria flatFileIndexCriteria = HibernateCriteria.forClass(FlatFileIndexEntity.class);
        Date slqDate = new Date(jodaDate.toDateTimeAtStartOfDay().getMillis());
        flatFileIndexCriteria.add(Restrictions.eq((String)"fileDate", (Object)slqDate));
        return (FlatFileIndexEntity)((FlatFileIndex_Dao)this.dao).findOne(flatFileIndexCriteria);
    }

    @Override
    public void deleteOlderThan(LocalDate jodaDate) {
        HibernateCriteria flatFileIndexCriteria = HibernateCriteria.forClass(FlatFileIndexEntity.class);
        Date slqDate = new Date(jodaDate.toDateTimeAtStartOfDay().getMillis());
        flatFileIndexCriteria.add(Restrictions.lt((String)"fileDate", (Object)slqDate));
        List flatFileHashRows = ((FlatFileIndex_Dao)this.dao).findByCriteria(flatFileIndexCriteria);
        flatFileHashRows.forEach(row -> ((FlatFileIndex_Dao)this.dao).delete(row));
        log.debug("DELETED");
    }
}

