/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.vendor.checker.services;

import com.suncode.plugin.vendor.checker.entity.FlatFileHashEntity;
import com.suncode.plugin.vendor.checker.entity.FlatFileHash_Dao;
import com.suncode.plugin.vendor.checker.services.FlatFileHashService;
import com.suncode.pwfl.support.hibernate.criterion.HibernateCriteria;
import com.suncode.pwfl.support.hibernate.criterion.Restrictions;
import com.suncode.pwfl.util.EditableServiceImpl;
import java.sql.Date;
import java.util.List;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class FlatFileHashServiceImpl
extends EditableServiceImpl<FlatFileHashEntity, Long, FlatFileHash_Dao>
implements FlatFileHashService {
    private static final Logger log = LoggerFactory.getLogger(FlatFileHashServiceImpl.class);

    @Autowired
    public void setDao(FlatFileHash_Dao dao) {
        this.dao = dao;
    }

    @Override
    public void save(String hash, LocalDate date) {
        FlatFileHashEntity entity = new FlatFileHashEntity();
        entity.setDate(date);
        entity.setHash(hash);
        ((FlatFileHash_Dao)this.dao).save(entity);
    }

    @Override
    public FlatFileHashEntity findOne(String hash, LocalDate jodaDate) {
        HibernateCriteria flatFileHashCriteria = HibernateCriteria.forClass(FlatFileHashEntity.class);
        Date slqDate = new Date(jodaDate.toDateTimeAtStartOfDay().getMillis());
        flatFileHashCriteria.add(Restrictions.eq((String)"hash", (Object)hash));
        flatFileHashCriteria.add(Restrictions.eq((String)"fileDate", (Object)slqDate));
        return (FlatFileHashEntity)((FlatFileHash_Dao)this.dao).findOne(flatFileHashCriteria);
    }

    @Override
    public void deleteOlderThan(LocalDate jodaDate) {
        List flatFileHashRows;
        HibernateCriteria flatFileHashCriteria = HibernateCriteria.forClass(FlatFileHashEntity.class);
        Date slqDate = new Date(jodaDate.toDateTimeAtStartOfDay().getMillis());
        flatFileHashCriteria.add(Restrictions.lt((String)"fileDate", (Object)slqDate));
        do {
            flatFileHashRows = ((FlatFileHash_Dao)this.dao).findByCriteria(flatFileHashCriteria, 0, 100000);
            flatFileHashRows.forEach(row -> ((FlatFileHash_Dao)this.dao).delete(row));
        } while (flatFileHashRows.size() == 100000);
        log.debug("Old data have been deleted from database");
    }
}

