/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.vendor.checker.services;

import com.suncode.plugin.vendor.checker.services.DownloadService;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.utils.IOUtils;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.stereotype.Service;

@Service
public class DownloadServiceImpl
implements DownloadService {
    private final String URL_PATH = "https://plikplaski.mf.gov.pl/pliki/";
    private final String ARCHIVE_EXTENSION = ".7z";
    private final String TEMP_DIRECTORY = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.WORKING_DIRECTORY);
    private final String FILE_EXTENSION = ".json";
    private DateTimeFormatter dtFormatter = DateTimeFormat.forPattern((String)"yyyyMMdd");

    @Override
    public File unpackJsonFile(File archiveFile) throws IOException {
        SevenZArchiveEntry entry;
        SevenZFile archive = SevenZFile.builder().setSeekableByteChannel(Files.newByteChannel(archiveFile.toPath(), new OpenOption[0])).get();
        String jsonFileName = archiveFile.getName().replace(".7z", ".json");
        String outputDirectory = this.TEMP_DIRECTORY;
        while ((entry = archive.getNextEntry()) != null) {
            String filename = Paths.get(entry.getName(), new String[0]).getFileName().toString();
            if (!filename.equals(jsonFileName)) continue;
            byte[] content = new byte[(int)entry.getSize()];
            archive.read(content, 0, content.length);
            File outputFile = new File(outputDirectory, filename);
            DataInputStream input = new DataInputStream(new BufferedInputStream(new ByteArrayInputStream(content)));
            Throwable throwable = null;
            try {
                FileOutputStream output = new FileOutputStream(outputFile);
                Throwable throwable2 = null;
                try {
                    IOUtils.copy((InputStream)input, (OutputStream)output);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (output == null) continue;
                    if (throwable2 != null) {
                        try {
                            output.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    output.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (input == null) continue;
                if (throwable != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                input.close();
            }
        }
        archive.close();
        return new File(this.TEMP_DIRECTORY + "/" + jsonFileName);
    }

    @Override
    public File downloadFlatFile(LocalDate fileDate) throws IOException {
        String filename = this.dtFormatter.print((ReadablePartial)fileDate);
        URL website = new URL("https://plikplaski.mf.gov.pl/pliki/" + filename + ".7z");
        ReadableByteChannel rbc = Channels.newChannel(website.openStream());
        File file = new File(this.TEMP_DIRECTORY + "/" + filename + ".7z");
        FileOutputStream fos = new FileOutputStream(file);
        fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
        fos.close();
        rbc.close();
        return file;
    }
}

