/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.vendor.checker.services;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.suncode.plugin.vendor.checker.engine.CheckOnlineEngine;
import com.suncode.plugin.vendor.checker.entity.FlatFileHashEntity;
import com.suncode.plugin.vendor.checker.entity.FlatFileMaskEntity;
import com.suncode.plugin.vendor.checker.enums.ApiMethod;
import com.suncode.plugin.vendor.checker.enums.CheckMessageResponse;
import com.suncode.plugin.vendor.checker.enums.VendorSource;
import com.suncode.plugin.vendor.checker.exception.ResponseException;
import com.suncode.plugin.vendor.checker.schemas.EntityCheck;
import com.suncode.plugin.vendor.checker.schemas.EntityCheckResponse;
import com.suncode.plugin.vendor.checker.schemas.ParamData;
import com.suncode.plugin.vendor.checker.schemas.ResponseData;
import com.suncode.plugin.vendor.checker.services.CheckService;
import com.suncode.plugin.vendor.checker.services.FlatFileHashService;
import com.suncode.plugin.vendor.checker.services.FlatFileIndexService;
import com.suncode.plugin.vendor.checker.services.FlatFileMaskService;
import com.suncode.plugin.vendor.checker.services.VendorCheckerService;
import com.suncode.plugin.vendor.checker.services.VendorLogService;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CheckServiceImpl
implements CheckService {
    private static final Logger log = LoggerFactory.getLogger(CheckServiceImpl.class);
    @Autowired
    private VendorCheckerService vendorCheckerService;
    @Autowired
    private CheckOnlineEngine checkOnlineEngine;
    @Autowired
    private FlatFileHashService ffHashService;
    @Autowired
    private FlatFileMaskService ffMaskService;
    @Autowired
    private VendorLogService vendorLogService;
    @Autowired
    private FlatFileIndexService ffIndexService;
    private DateTimeFormatter dtFormatter = DateTimeFormat.forPattern((String)"yyyyMMdd");
    private final LoadingCache<ParamData, ResponseData<EntityCheckResponse>> empCache = CacheBuilder.newBuilder().maximumSize(8000L).expireAfterWrite(1L, TimeUnit.DAYS).build((CacheLoader)new CacheLoader<ParamData, ResponseData<EntityCheckResponse>>(){

        public ResponseData<EntityCheckResponse> load(ParamData param) throws Exception {
            return CheckServiceImpl.this.checkProcedure(param);
        }
    });

    @Override
    public ResponseData<EntityCheckResponse> check(ParamData param, String processId) throws ExecutionException {
        ResponseData response = new ResponseData();
        try {
            log.debug("Get data from cache");
            this.logVendor(param);
            response = (ResponseData)this.empCache.get((Object)param);
            if (response.getSuccess().booleanValue()) {
                String status = response.getMessage();
                String requestId = ((EntityCheckResponse)response.getData()).getResult().getRequestId();
                try {
                    this.vendorCheckerService.saveEntity(status, requestId, param, processId, response.getMethod());
                }
                catch (Exception e) {
                    log.trace("SKIP: Error to save: pm_vendor_checker");
                    log.trace("Request id: " + requestId);
                    log.trace("Status: " + status);
                    log.trace(e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (ExecutionException uHE) {
            if (uHE.getCause() instanceof ResponseException) {
                ResponseException re = (ResponseException)uHE.getCause();
                log.info("Don 't save to cache");
                log.info(re.getMessage());
                response.setMessage(re.getMessage());
                return response;
            }
            log.error(uHE.getMessage(), (Throwable)uHE);
            throw uHE;
        }
        catch (Exception e) {
            log.info(processId);
            log.error(param.toString(), (Throwable)e);
            response.setMessage(e.getMessage());
        }
        return response;
    }

    private void logVendor(ParamData param) {
        ResponseData response = (ResponseData)this.empCache.getIfPresent((Object)param);
        if (response != null) {
            String info = this.buildInfo(param);
            String status = response.getMessage();
            this.vendorLogService.save(DateTime.now(), status, VendorSource.CACHE, info);
        }
    }

    private String buildInfo(ParamData param) {
        StringBuilder sb = new StringBuilder();
        sb.append("DATA:\t").append(" NIP: ").append(param.getSanitizedNIP()).append("\t").append(" NRB: ").append(param.getSanitizedNRB()).append("\t").append(" DATE: ").append(param.getDate()).append("\t");
        return sb.toString();
    }

    private ResponseData<EntityCheckResponse> checkProcedure(ParamData param) throws IOException, NoSuchAlgorithmException, ResponseException {
        if (this.ffIndexService.checkExist(param.getDate()).booleanValue()) {
            try {
                return this.checkInDB(param);
            }
            catch (Exception e) {
                log.debug("CheckInDB Error:\t" + e.getMessage(), (Throwable)e);
                log.debug("Checking Online");
                return this.checkOnlineEngine.check(param);
            }
        }
        return this.checkOnlineEngine.check(param);
    }

    private ResponseData<EntityCheckResponse> checkInDB(ParamData param) throws NoSuchAlgorithmException, IOException, ExecutionException {
        ResponseData<EntityCheckResponse> response = new ResponseData<EntityCheckResponse>();
        response.setMessage(CheckMessageResponse.NO.getMsg());
        EntityCheckResponse data = new EntityCheckResponse();
        EntityCheck result = new EntityCheck();
        result.setAccountAssigned("NIE");
        result.setRequestId("flatfile-" + UUID.randomUUID().toString());
        LocalDate jodaDate = param.getDate();
        String dateStr = this.dtFormatter.print((ReadablePartial)jodaDate);
        String nip = param.getSanitizedNIP();
        String nrb = param.getSanitizedNRB();
        String hash = this.genarateSHA512(dateStr + nip + nrb);
        FlatFileHashEntity finded = this.ffHashService.findOne(hash, jodaDate);
        if (finded != null) {
            response.setMessage(CheckMessageResponse.YES.getMsg());
            result.setAccountAssigned("TAK");
        } else {
            List<String> masks = this.buildMask(nrb);
            Boolean checkOnline = true;
            for (String mask : masks) {
                hash = this.genarateSHA512(dateStr + nip + mask);
                finded = this.ffHashService.findOne(hash, jodaDate);
                if (finded == null) continue;
                response.setMessage(CheckMessageResponse.YES_VIRTUAL.getMsg());
                result.setAccountAssigned("TAK");
                checkOnline = false;
                break;
            }
            if (checkOnline.booleanValue()) {
                return this.checkOnlineEngine.check(param);
            }
        }
        data.setResult(result);
        response.setData(data);
        response.setMethod(ApiMethod.FLAT_FILE);
        response.setSuccess(true);
        String info = this.buildInfo(param);
        this.vendorLogService.save(DateTime.now(), response.getMessage(), VendorSource.DATABASE, info);
        return response;
    }

    private List<String> buildMask(String nrb) {
        ArrayList<String> result = new ArrayList<String>();
        String bankNumber = nrb.substring(2, 10);
        List<FlatFileMaskEntity> mask = this.ffMaskService.find(bankNumber);
        log.debug("BankNumber:\t" + bankNumber);
        if (!mask.isEmpty()) {
            for (FlatFileMaskEntity flatFileMaskEntity : mask) {
                String bankMask = flatFileMaskEntity.getMask();
                StringBuilder sb = new StringBuilder();
                for (int indexChar = 0; indexChar < bankMask.length(); ++indexChar) {
                    if (bankMask.charAt(indexChar) == 'Y') {
                        sb.append(nrb.charAt(indexChar));
                        continue;
                    }
                    sb.append(bankMask.charAt(indexChar));
                }
                log.debug("NRB:\t" + nrb);
                log.debug("MASK:\t" + bankMask);
                log.debug("BUILD MASK:\t" + sb.toString());
                result.add(sb.toString());
            }
        }
        return result;
    }

    private String genarateSHA512(String stringToHash) throws NoSuchAlgorithmException {
        String tempHash = stringToHash.trim();
        log.debug("toSHA-512:\t" + tempHash);
        MessageDigest md = MessageDigest.getInstance("SHA-512");
        int numberOfTransformations = 5000;
        for (int transformationNr = 0; transformationNr < numberOfTransformations; ++transformationNr) {
            byte[] bytes = md.digest(tempHash.getBytes(StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < bytes.length; ++i) {
                sb.append(Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1));
            }
            tempHash = sb.toString();
        }
        log.debug("Hash:\t" + tempHash);
        return tempHash;
    }
}

