/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.vendor.checker.entity;

import java.sql.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.joda.time.LocalDate;

@Entity
@Table(name="pm_vendor_checker", uniqueConstraints={@UniqueConstraint(columnNames={"id"}), @UniqueConstraint(columnNames={"requestid"})})
@SequenceGenerator(name="pm_vendor_checker_seq", sequenceName="pm_vendor_checker_seq")
public class VendorCheckerEntity {
    public static final String TABLE_NAME = "pm_vendor_checker";
    public static final String REQUESTID_CNAME = "requestid";
    public static final String ID_CNAME = "id";
    public static final String SEQUENCER_NAME = "pm_vendor_checker_seq";
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="pm_vendor_checker_seq")
    @Column(name="id", unique=true, nullable=false)
    private Long id;
    @Column(name="processid", nullable=false)
    private String processId;
    @Column(name="requestid", unique=true, nullable=false)
    private String requestid;
    @Column(name="execute_date")
    private Date executeDate;
    @Column(name="param_date")
    private Date date;
    @Column(name="param_iban")
    private String iban;
    @Column(name="param_nip")
    private String nip;
    @Column(name="status")
    private String status;
    @Column(name="method")
    private String method;
    @Column(name="param_regon")
    private String ragon;

    public void setDate(LocalDate localDate) {
        this.date = new Date(localDate.toDateTimeAtStartOfDay().getMillis());
    }

    public void setExecuteDate(LocalDate localDate) {
        this.executeDate = new Date(localDate.toDateTimeAtStartOfDay().getMillis());
    }

    public String toString() {
        return "RequestID [id=" + this.id + ", processId=" + this.processId + ", requestid=" + this.requestid + ", executeDate=" + this.executeDate + ", date=" + this.date + ", iban=" + this.iban + ", nip=" + this.nip + ", status=" + this.status + ", method=" + this.method + ", ragon=" + this.ragon + "]";
    }

    public Long getId() {
        return this.id;
    }

    public String getProcessId() {
        return this.processId;
    }

    public String getRequestid() {
        return this.requestid;
    }

    public Date getExecuteDate() {
        return this.executeDate;
    }

    public Date getDate() {
        return this.date;
    }

    public String getIban() {
        return this.iban;
    }

    public String getNip() {
        return this.nip;
    }

    public String getStatus() {
        return this.status;
    }

    public String getMethod() {
        return this.method;
    }

    public String getRagon() {
        return this.ragon;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public void setRequestid(String requestid) {
        this.requestid = requestid;
    }

    public void setIban(String iban) {
        this.iban = iban;
    }

    public void setNip(String nip) {
        this.nip = nip;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setRagon(String ragon) {
        this.ragon = ragon;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VendorCheckerEntity)) {
            return false;
        }
        VendorCheckerEntity other = (VendorCheckerEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$processId = this.getProcessId();
        String other$processId = other.getProcessId();
        if (this$processId == null ? other$processId != null : !this$processId.equals(other$processId)) {
            return false;
        }
        String this$requestid = this.getRequestid();
        String other$requestid = other.getRequestid();
        if (this$requestid == null ? other$requestid != null : !this$requestid.equals(other$requestid)) {
            return false;
        }
        Date this$executeDate = this.getExecuteDate();
        Date other$executeDate = other.getExecuteDate();
        if (this$executeDate == null ? other$executeDate != null : !((Object)this$executeDate).equals(other$executeDate)) {
            return false;
        }
        Date this$date = this.getDate();
        Date other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        String this$iban = this.getIban();
        String other$iban = other.getIban();
        if (this$iban == null ? other$iban != null : !this$iban.equals(other$iban)) {
            return false;
        }
        String this$nip = this.getNip();
        String other$nip = other.getNip();
        if (this$nip == null ? other$nip != null : !this$nip.equals(other$nip)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$ragon = this.getRagon();
        String other$ragon = other.getRagon();
        return !(this$ragon == null ? other$ragon != null : !this$ragon.equals(other$ragon));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VendorCheckerEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $processId = this.getProcessId();
        result = result * 59 + ($processId == null ? 43 : $processId.hashCode());
        String $requestid = this.getRequestid();
        result = result * 59 + ($requestid == null ? 43 : $requestid.hashCode());
        Date $executeDate = this.getExecuteDate();
        result = result * 59 + ($executeDate == null ? 43 : ((Object)$executeDate).hashCode());
        Date $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        String $iban = this.getIban();
        result = result * 59 + ($iban == null ? 43 : $iban.hashCode());
        String $nip = this.getNip();
        result = result * 59 + ($nip == null ? 43 : $nip.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $ragon = this.getRagon();
        result = result * 59 + ($ragon == null ? 43 : $ragon.hashCode());
        return result;
    }
}

