/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.vendor.checker.engine;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.gson.Gson;
import com.suncode.plugin.vendor.checker.engine.SearchNipEngine;
import com.suncode.plugin.vendor.checker.enums.ApiMethod;
import com.suncode.plugin.vendor.checker.enums.SystemParametersKey;
import com.suncode.plugin.vendor.checker.enums.VendorSource;
import com.suncode.plugin.vendor.checker.exception.ResponseException;
import com.suncode.plugin.vendor.checker.schemas.Entity;
import com.suncode.plugin.vendor.checker.schemas.EntityException;
import com.suncode.plugin.vendor.checker.schemas.EntityResponse;
import com.suncode.plugin.vendor.checker.schemas.Entry;
import com.suncode.plugin.vendor.checker.schemas.EntryListResponse;
import com.suncode.plugin.vendor.checker.schemas.ParamData;
import com.suncode.plugin.vendor.checker.schemas.ResponseData;
import com.suncode.plugin.vendor.checker.services.VendorLogService;
import com.suncode.plugin.vendor.checker.utils.NetTools;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchNipEngineImpl
implements SearchNipEngine {
    private static final Logger log = LoggerFactory.getLogger(SearchNipEngineImpl.class);
    @Autowired
    private VendorLogService vendorLogService;
    private static final Gson GSON = new Gson();

    @Override
    public ResponseData<EntityResponse> searchNip(ParamData param) throws IOException, ResponseException {
        String apiResource = "/api/search/nip/" + param.getSanitizedNIP();
        GenericUrl genericUrl = this.buildGenericUrl(param, apiResource);
        return this.executeNIPSearch(genericUrl, param);
    }

    @Override
    public ResponseData<EntryListResponse> searchNips(ParamData param) throws IOException, ResponseException {
        String apiResource = "/api/search/nips/" + param.getSanitizedNIPs();
        GenericUrl genericUrl = this.buildGenericUrl(param, apiResource);
        return this.executeNIPsSearch(genericUrl, param);
    }

    private GenericUrl buildGenericUrl(ParamData param, String apiResource) {
        String hostUrl = SystemProperties.getString((String)SystemParametersKey.SERWER_HOST.getName());
        if (StringUtils.isBlank((CharSequence)hostUrl)) {
            throw new RuntimeException("Not set parameter " + SystemParametersKey.SERWER_HOST.getName());
        }
        String url = hostUrl + apiResource;
        GenericUrl genericUrl = new GenericUrl(url);
        genericUrl.put("date", (Object)param.getDate().toString());
        return genericUrl;
    }

    private ResponseData<EntryListResponse> executeNIPsSearch(GenericUrl genericUrl, ParamData param) throws ResponseException, IOException {
        try {
            HttpResponse response = this.executeGetRequest(genericUrl);
            String responseJSON = NetTools.readContent(response.getContent());
            int statusCode = response.getStatusCode();
            log.debug("StatusCode " + statusCode);
            log.debug(responseJSON);
            EntryListResponse entryListResponse = (EntryListResponse)GSON.fromJson(responseJSON, EntryListResponse.class);
            ResponseData<EntryListResponse> responseData = new ResponseData<EntryListResponse>();
            responseData.setSuccess(true);
            responseData.setData(entryListResponse);
            responseData.setMessage(this.buildMessage(entryListResponse.getResult().getEntries()));
            responseData.setMethod(ApiMethod.SEARCH_NIPS);
            this.logVendor(genericUrl.build(), statusCode, responseData.getMessage());
            return responseData;
        }
        catch (HttpResponseException httpException) {
            log.debug("HttpResponseException");
            log.debug("StatusCode: {}", (Object)httpException.getStatusCode());
            log.debug("Content: {}", (Object)httpException.getContent());
            if (httpException.getStatusCode() == 400 || httpException.getStatusCode() == 420 || httpException.getStatusCode() == 429) {
                EntityException entityException = (EntityException)GSON.fromJson(httpException.getContent(), EntityException.class);
                ResponseException re = new ResponseException(entityException.getMessage(), entityException);
                this.logVendor(genericUrl.build(), httpException.getStatusCode(), entityException.getMessage());
                throw re;
            }
            this.logVendor(genericUrl.build(), httpException.getStatusCode(), httpException.getContent());
            throw httpException;
        }
    }

    private String buildMessage(Entity entity) {
        return "Found " + (entity == null ? 0 : 1) + " entity";
    }

    private String buildMessage(Entry[] entry) {
        long count = Arrays.asList(entry).stream().filter(item -> item.getSubjects() != null).count();
        return "Found " + count + " entities";
    }

    private ResponseData<EntityResponse> executeNIPSearch(GenericUrl genericUrl, ParamData param) throws IOException, ResponseException {
        try {
            HttpResponse response = this.executeGetRequest(genericUrl);
            String responseContent = NetTools.readContent(response.getContent());
            int statusCode = response.getStatusCode();
            log.debug("StatusCode " + statusCode);
            log.debug(responseContent);
            EntityResponse entityResponse = (EntityResponse)GSON.fromJson(responseContent, EntityResponse.class);
            ResponseData<EntityResponse> responseData = new ResponseData<EntityResponse>();
            responseData.setSuccess(true);
            responseData.setData(entityResponse);
            Entity entity = entityResponse.getResult().getSubject();
            responseData.setMessage(this.buildMessage(entity));
            responseData.setMethod(ApiMethod.SEARCH_NIP);
            this.logVendor(genericUrl.build(), statusCode, responseData.getMessage());
            return responseData;
        }
        catch (HttpResponseException httpException) {
            log.debug("HttpResponseException");
            log.debug("StatusCode: {}", (Object)httpException.getStatusCode());
            log.debug("Content: {}", (Object)httpException.getContent());
            if (httpException.getStatusCode() == 400 || httpException.getStatusCode() == 420 || httpException.getStatusCode() == 429) {
                EntityException entityException = (EntityException)GSON.fromJson(httpException.getContent(), EntityException.class);
                ResponseException re = new ResponseException(entityException.getMessage(), entityException);
                this.logVendor(genericUrl.build(), httpException.getStatusCode(), entityException.getMessage());
                throw re;
            }
            this.logVendor(genericUrl.build(), httpException.getStatusCode(), httpException.getContent());
            throw httpException;
        }
    }

    private HttpResponse executeGetRequest(GenericUrl genericUrl) {
        HttpRequestFactory requestFactory = new NetHttpTransport().createRequestFactory();
        HttpRequest requestGET = requestFactory.buildGetRequest(genericUrl);
        log.debug("REQUEST URL\t" + requestGET.getUrl().build());
        HttpResponse response = requestGET.execute();
        Thread.sleep(150L);
        return response;
    }

    private void logVendor(String url, int httpCode, String message) {
        String info = "URL:\t" + url;
        this.vendorLogService.save(DateTime.now(), message, VendorSource.ONLINE, info, httpCode);
    }
}

