/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.vendor.checker.engine;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.suncode.plugin.vendor.checker.engine.SearchBankAccountEngine;
import com.suncode.plugin.vendor.checker.enums.ApiMethod;
import com.suncode.plugin.vendor.checker.enums.SystemParametersKey;
import com.suncode.plugin.vendor.checker.enums.VendorSource;
import com.suncode.plugin.vendor.checker.exception.ResponseException;
import com.suncode.plugin.vendor.checker.schemas.EntityCheckResponse;
import com.suncode.plugin.vendor.checker.schemas.EntityException;
import com.suncode.plugin.vendor.checker.schemas.EntityListResponse;
import com.suncode.plugin.vendor.checker.schemas.ParamData;
import com.suncode.plugin.vendor.checker.schemas.ResponseData;
import com.suncode.plugin.vendor.checker.services.VendorLogService;
import com.suncode.plugin.vendor.checker.utils.NetTools;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CheckOnlineEngine {
    private static final Logger log = LoggerFactory.getLogger(CheckOnlineEngine.class);
    @Autowired
    private SearchBankAccountEngine searchBankAccountEngine;
    @Autowired
    private VendorLogService vendorLogService;
    private HttpRequestFactory requestFactory;
    private static final Gson GSON = new Gson();

    public ResponseData<EntityCheckResponse> check(ParamData param) throws IOException, ResponseException {
        log.debug("Execute online");
        this.init();
        ResponseData<EntityCheckResponse> response = this.checkNIP(param);
        if (response.getSuccess().booleanValue() && response.getMessage().equalsIgnoreCase("NIE")) {
            this.checkIsVirtualAccount(param, response);
        }
        return response;
    }

    private void checkIsVirtualAccount(ParamData param, ResponseData<EntityCheckResponse> response) throws ResponseException, IOException {
        if (response.getSuccess().booleanValue() && response.getMessage().equalsIgnoreCase("NIE")) {
            log.debug("Check is VirtualAccount");
            ResponseData<EntityListResponse> result = this.searchBankAccountEngine.searchBankAccount(param);
            if (result.getSuccess().booleanValue()) {
                response.setMessage(result.getMessage());
                response.setMethod(result.getMethod());
            }
        }
    }

    private void init() {
        this.requestFactory = new NetHttpTransport().createRequestFactory();
    }

    private ResponseData<EntityCheckResponse> checkNIP(ParamData param) throws IOException, ResponseException {
        String hostUrl = SystemProperties.getString((String)SystemParametersKey.SERWER_HOST.getName());
        this.init();
        if (StringUtils.isBlank((CharSequence)hostUrl)) {
            throw new RuntimeException("Not set parameter " + SystemParametersKey.SERWER_HOST.getName());
        }
        String apiResource = "/api/check/nip/" + param.getSanitizedNIP() + "/bank-account/" + param.getSanitizedNRB();
        String url = hostUrl + apiResource;
        GenericUrl genericUrl = new GenericUrl(url);
        genericUrl.put("date", (Object)(param.getDate() == null ? "" : param.getDate().toString()));
        return this.executeCheck(genericUrl);
    }

    private ResponseData<EntityCheckResponse> executeCheck(GenericUrl genericUrl) throws IOException, ResponseException {
        log.debug("REQUEST URL\t" + genericUrl.build());
        try {
            HttpRequest requestGET = this.requestFactory.buildGetRequest(genericUrl);
            HttpResponse response = requestGET.execute();
            int statusCode = response.getStatusCode();
            log.debug("StatusCode " + statusCode);
            String entityCheckJson = NetTools.readContent(response.getContent());
            log.debug(entityCheckJson);
            EntityCheckResponse entityCheckResponse = (EntityCheckResponse)GSON.fromJson(entityCheckJson, EntityCheckResponse.class);
            ResponseData<EntityCheckResponse> responseData = new ResponseData<EntityCheckResponse>();
            responseData.setSuccess(true);
            responseData.setData(entityCheckResponse);
            responseData.setMessage(entityCheckResponse.getResult().getAccountAssigned());
            responseData.setMethod(ApiMethod.CHECK);
            this.logVendor(genericUrl.build(), statusCode, responseData.getMessage());
            return responseData;
        }
        catch (HttpResponseException httpException) {
            log.debug("HttpResponseException");
            log.debug("StatusCode: {}", (Object)httpException.getStatusCode());
            log.debug("Content: {}", (Object)httpException.getContent());
            if (httpException.getStatusCode() == 400 || httpException.getStatusCode() == 420 || httpException.getStatusCode() == 429) {
                EntityException entityException = this.parseEntityException(httpException.getContent());
                ResponseException re = new ResponseException(entityException.getMessage(), entityException);
                this.logVendor(genericUrl.build(), httpException.getStatusCode(), entityException.getMessage());
                throw re;
            }
            this.logVendor(genericUrl.build(), httpException.getStatusCode(), httpException.getContent());
            throw httpException;
        }
    }

    private EntityException parseEntityException(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            log.debug("Empty response");
            EntityException entityException = new EntityException();
            entityException.setMessage("Otrzymano pust\u0105 odpowied\u017a z serwera.");
            return entityException;
        }
        try {
            return (EntityException)GSON.fromJson(content, EntityException.class);
        }
        catch (JsonSyntaxException e) {
            log.debug("Failed to parse as JSON object", (Object)e.getMessage());
            EntityException entityException = new EntityException();
            entityException.setMessage(content);
            return entityException;
        }
    }

    private void logVendor(String url, int httpCode, String message) {
        String info = "URL:\t" + url;
        this.vendorLogService.save(DateTime.now(), message, VendorSource.ONLINE, info, httpCode);
    }
}

