PWE.integrationComponent.registerApplication('vendor.checker.entity-info.app', {
    apiVersion: 2,
    buildForm: function (form) {
        _vendorEnitiyInfoBuildForm(form, false)
    },
    validateForm: function (api) {
        return _validEntity(api);
    }
});

PWE.integrationComponent.registerVariablesSetter('vendor.checker.entity-info.app', {
    apiVersion: 2,
    buildForm: function (form) {
        _vendorEnitiyInfoBuildForm(form, false)
    },
    validateForm: function (api) {
        return _validEntity(api);
    }
});

PWE.integrationComponent.registerFormAction('vendor.checker.entity-info.action', {
    apiVersion: 2,
    buildForm: function (form, options) {
        _vendorEnitiyInfoBuildForm(form, (options.destination == "VARIABLE"))
    },
    validateForm: function (api) {
        return _validEntity(api);
    }
});

function _validEntity(api) {
    var error = false;
    jQuery.ajax({
        url: PW.getAbsolutePath('plugin/com.suncode.plugin-vendor.checker/dpwe/entitytypes'),
        type: 'GET',
        async: false,
        success: function (responseData) {
            var variableTypes = api.getVariableType("variables");
            var entityValues = api.getValue("entityParamsName", false);
            for (var index = 0; index < entityValues.length; index++) {
                if (!responseData.hasOwnProperty(entityValues[index]) || variableTypes[index] !== responseData[entityValues[index]]) {
                    error = true;
                    api.markError("variables", index);
                }
            }
        }
    });
    if (error) {
        api.showErrorMessage(VENDOR.t("dpwe.error.mapping"))
    }
    return !error;
}

function _vendorEnitiyInfoBuildForm(form, offNipOrNrb) {
    //Parameter Input FieldSet
    var filedSetInputParam = form.addFieldSet({
        title: VENDOR.t("dpwe.label.input"),
        collapsible: true,
    });
    var row = filedSetInputParam.addRow({
        id: 'input',
    })

    if (!offNipOrNrb) {
        row.addField({ id: 'nipOrNrb',notEmpty: true, optional: false });
    }
    row.addCombobox({
        id: "searchType",
        values: [
            { id: "NIP", display: VENDOR.t("dpwe.label.nip") },
            { id: "NRB", display: VENDOR.t("dpwe.label.bank-account") }
        ]
    });
    row.addField('date');

    //Parameter output FieldSet
    var filedSetOutputParam = form.addFieldSet({
        title: VENDOR.t("dpwe.label.output"),
        collapsible: true,
    });
    var mappingTable = filedSetOutputParam.addTable({
        id: 'mappingTable',
    })
    mappingTable.addCombobox({
        id: "entityParamsName",
        remote: {
            url: "plugin/com.suncode.plugin-vendor.checker/dpwe/entityparams",
            fields: [
                {
                    name: "name",
                    type: "string"
                },
                {
                    name: "displayName",
                    type: "string"
                },
                ,
                {
                    name: "description",
                    type: "string"
                },
                ,
                {
                    name: "type",
                    type: "string"
                }
            ]
        },
        template: [
            {
                label: VENDOR.t("dpwe.combobox.label.name"),
                field: "displayName"
            },
            {
                label: VENDOR.t("dpwe.combobox.label.desc"),
                field: "description"
            },
            {
                label: VENDOR.t("dpwe.combobox.label.type"),
                field: "type"
            }
        ],
        valueField: "name",
        displayField: "displayName",
        sort: [{
            property: "displayName",
            direction: "ASC"
        }],
    });
    mappingTable.addField('variables');

    //Processing Parameter FieldSet
    var filedSetProcessingParam = form.addFieldSet({
        title: VENDOR.t("dpwe.label.errorStatus"),
        collapsible: true,
        collapsed: true
    });
    filedSetProcessingParam.addField("processingStatus");
    filedSetProcessingParam.addField("comment");
}