PWE.integrationComponent.registerApplication('vendor.checker.entities-info.app', {
    apiVersion: 2,
    buildForm: function (form) {
        _vendorEnitiesInfoBuildForm(form, false)
    },
    validateForm: function (api) {
        return _validEntities(api);
    }
});

PWE.integrationComponent.registerVariablesSetter('vendor.checker.entities-info.app', {
    apiVersion: 2,
    buildForm: function (form) {
        _vendorEnitiesInfoBuildForm(form, false)
    },
    validateForm: function (api) {
        return _validEntities(api);
    }
});

PWE.integrationComponent.registerFormAction('vendor.checker.entities-info.action', {
    apiVersion: 2,
    buildForm: function (form, options) {
        _vendorEnitiesInfoBuildForm(form, (options.destination == "FORM"))
    },
    validateForm: function (api) {
        return _validEntities(api);
    }
});

function _validEntities(api) {
    var error = false;
    jQuery.ajax({
        url: PW.getAbsolutePath('plugin/com.suncode.plugin-vendor.checker/dpwe/entityheadertypes'),
        type: 'GET',
        async: false,
        success: function (responseData) {
            var variableTypes = api.getVariableType("variables");
            var entityValues = api.getValue("entityParamsName", false);
            for (var index = 0; index < entityValues.length; index++) {
                if (!responseData.hasOwnProperty(entityValues[index]) || variableTypes[index] !== responseData[entityValues[index]]) {
                    error = true;
                    api.markError("variables", index);
                }
            }
        }
    });
    if (error) {
        api.showErrorMessage(VENDOR.t("dpwe.error.mapping"))
    }
    return !error;
}

function _vendorEnitiesInfoBuildForm(form, isForm) {
    //Parameter Input FieldSet
    var filedSetInputParam = form.addFieldSet({
        title: VENDOR.t("dpwe.label.input"),
        collapsible: true,
    });
    var row = filedSetInputParam.addRow({
        id: 'input',
    })

    row.addField({ id: 'nipsOrNrbs', notEmpty: true, optional: false, });
    row.addCombobox({
        id: "searchType",
        values: [
            { id: "NIPS", display: VENDOR.t("dpwe.label.nips") },
            { id: "NRBS", display: VENDOR.t("dpwe.label.bank-accounts") }
        ]
    });
    row.addField({ id: 'dates' });

    if (isForm) {
        filedSetInputParam.addField({ id: 'tableId', notEmpty: true, optional: false, });
    }
    //Parameter output FieldSet
    var filedSetOutputParam = form.addFieldSet({
        title: VENDOR.t("dpwe.label.output"),
        collapsible: true,
    });
    var mappingTable = filedSetOutputParam.addTable({
        id: 'mappingTable',
    })
    mappingTable.addCombobox({
        id: "entityParamsName",
        remote: {
            url: "plugin/com.suncode.plugin-vendor.checker/dpwe/entityheaderparams",
            fields: [
                {
                    name: "name",
                    type: "string"
                },
                {
                    name: "displayName",
                    type: "string"
                },
                ,
                {
                    name: "description",
                    type: "string"
                },
                ,
                {
                    name: "type",
                    type: "string"
                }
            ]
        },
        template: [
            {
                label: VENDOR.t("dpwe.combobox.label.name"),
                field: "displayName"
            },
            {
                label: VENDOR.t("dpwe.combobox.label.desc"),
                field: "description"
            },
            {
                label: VENDOR.t("dpwe.combobox.label.type"),
                field: "type"
            }
        ],
        valueField: "name",
        displayField: "displayName",
        sort: [{
            property: "displayName",
            direction: "ASC"
        }],
    });
    mappingTable.addField('variables');

    //Processing Parameter FieldSet
    var filedSetProcessingParam = form.addFieldSet({
        title: VENDOR.t("dpwe.label.errorStatus"),
        collapsible: true,
        collapsed: true
    });
    filedSetProcessingParam.addField("processingStatus");
    filedSetProcessingParam.addField("comment");
}