PW.FormActions.create('vendor.checker.table-check-iban.action', {
	variableSetInit: function (table) {
		this.variableSet = VariableSetService.get(table.getId());
		this.clomunsIds = [];
		var me = this;
		if (this.get('updateColumns')) {
			jQuery(this.get('updateColumns')).each(
				function (index, item) {
					me.clomunsIds.push(item.getId());
				});
		}
	},

	dtButtonInit: function (button) {
		this.variableSet = VariableSetService
			.get(button.variableSet.getId());
	},
	defaultActions: {
		button: function (button) {},
		variable: function (variable, newValue, oldValue) {},
		variableSet: function (variableSet, added, updated,
			removed) {
			if (updated.length > 0) {
				for (updateIndex = 0; updateIndex < updated.length; updateIndex++) {
					var currentRow = updated[updateIndex].index;
					for (indexColumn = 0; indexColumn < updated[updateIndex].changes.length; indexColumn++) {
						if (this.clomunsIds.includes(updated[updateIndex].changes[indexColumn])) {
							this.checkUpdate(currentRow);
						}
					}
				}
			}

		},
		dtButton: function (button) {
			this.checkBtn();
		}
	},
	checkUpdate: function (row) {
		let condition = this.get("condition");
		if (condition !== null && condition !== undefined) {
			this.setContextVariable("currentRow", row);
			if (!condition.call()) {
				return;
			}
		}

		FormService.mask();
		var me = this;
		var statusVar = this.get('status');
		var requestIdVar = this.get('requestId');
		var isOnComment = this.get('comment');
		var nips = this.get('nip_regon');
		var ibans = this.get('iban');
		var dates = this.get('date');
		var addRequestId=this.get('addRequestId');
		var nip = nips.length == 1 ? nips[0] :
			nips[row];
		var iban = ibans.length == 1 ? ibans[0] : ibans[row];
		var date = '';
		if (dates) {
			date = dates.length == 1 ? dates[0] : dates[row];
		}
		jQuery.ajax({
			url: 'plugin/com.suncode.plugin-vendor.checker/api/check/iban',
			type: 'POST',
			contentType: "application/x-www-form-urlencoded",
			data: {
				nip: nip,
				iban: iban,
				date: date ? date.dateFormat('Y-m-d') : null,
				processid: processId
			},
			success: function (result) {
				var msg = result.message;
				var valid = false;
				if (result.success) {
					msg = VENDOR.t(result.commentKey, result.commentValue, result.commentIban);
					if(addRequestId){
						msg+=" "+VENDOR.t('comment.requestID',result.reuestId);
	                   }
				}
				if (statusVar) {
					VariableSetService.setValue(me.variableSet, row, statusVar.getId(), result.message);
				} else {
					valid = (result.message == "TAK") || (result.message == "TAK - Konto wirtualne") ? true : false;
					if (valid) {
						MessageService.showSuccess(msg);
					} else {
						MessageService.showFailure(msg);
					}
				}
				if (isOnComment) {
					CommentService.add(msg);
				}

				if (requestIdVar) {
					VariableSetService.setValue(me.variableSet, row, requestIdVar.getId(), result.reuestId);
				}
				FormService.unmask();
				return true;

			},
			error: function () {
				FormService.unmask();
				MessageService.showFailure(VENDOR.t('server.error'));
				return false;
			}
		});
	},
	checkBtn: function () {
		FormService.mask();
		var me = this;
		var statusVar = this.get('status');
		var requestIdVar = this.get('requestId');
		var isOnComment = this.get('comment');
		var addRequestId=this.get('addRequestId');
		var nips = this.get('nip_regon');
		var iban = this.get('iban');
		var date = this.get('date');
		var dates = [];
		for (i = 0; i < date.length; i++) {
			if (date[i]) {
				dates.push((date[i].dateFormat('Y-m-d')))
			} else {
				dates.push('');
			}
		}

		let condition = this.get("condition");
		let filteredIndexes = [];
		if (condition !== null && condition !== undefined) {
			let nipsFiltered = [], ibanFiltered = [], datesFiltered = [];
			for (let i = 0; i < nips.length; i++) {
				this.setContextVariable("currentRow", i);
				if (condition.call()) {
					filteredIndexes.push(i);
					nipsFiltered.push(nips[i]);
					ibanFiltered.push(iban[i]);
					datesFiltered.push(dates[i]);
				}
			}
            nips = nipsFiltered;
            iban = ibanFiltered;
            dates = datesFiltered;
		}
		if (nips.length === 0) {
			FormService.unmask();
			MessageService.show(VENDOR.t('information.noRecordSelected'));
			return;
		}
		if (dates.length === 0) {
			dates.push('');
		}

		jQuery.ajax({
			url: 'plugin/com.suncode.plugin-vendor.checker/api/check/ibans',
			type: 'POST',
			contentType: "application/x-www-form-urlencoded",
			data: {
				nips: nips,
				ibans: iban,
				dates: dates,
				processid: processId
			},
			success: function (result) {
				var successCount = 0;
				var message = "";
				if (!result.success) {
					message = result.message;
					MessageService.showFailure(message);
				} else {
					for (i = 0; i < result.data.length; i++) {
						if (i > 0) {
							message += "<br>";
						}
						if (result.data[i].success) {
							if((result.data[i].message == "TAK") || (result.data[i].message == "TAK - Konto wirtualne")) {
								successCount++;
							}
							message += VENDOR.t(result.data[i].commentKey, result.data[i].commentValue, result.data[i].commentIban);
							if(addRequestId){
								message +="	"+VENDOR.t('comment.requestID',result.data[i].reuestId);
							}
						} else {
							message += result.data[i].message;
						}

						let index = (condition !== null && condition !== undefined) ? filteredIndexes[i] : i;
						if (requestIdVar) {
							VariableSetService.setValue(me.variableSet, index, requestIdVar.getId(), result.data[i].reuestId);
						}
						if (statusVar) {
							VariableSetService.setValue(me.variableSet, index, statusVar.getId(), result.data[i].message);
						}
					}
					if (!statusVar) {
						if (successCount == result.data.length) {
							MessageService.showSuccess(message);
						} else {
							MessageService.showFailure(message);
						}
					}
				}
				if (isOnComment) {
					CommentService.add(message);
				}
				FormService.unmask();
				return true;
			},
			error: function () {
				FormService.unmask();
				MessageService.showFailure(VENDOR.t('server.error'));
				return false;
			}
		});
	}
});