PW.FormActions.create('vendor.checker.check-iban.action', {
    defaultActions: {
        button: function (button) {
            this.check();
        },
        variable: function (variable, newValue, oldValue) {
            this.check();
        },
        variableSet: function (variableSet, added, updated, removed) {}
    },
    check: function () {
        FormService.mask();
        var statusVar = this.get('status');
        var requestIdVar = this.get('requestId');
        var isOnComment = this.get('comment');
        var nip = this.get('nip_regon');
        var iban = this.get('iban');
        var date = this.get('date');
        var addRequestId=this.get('addRequestId');
        jQuery.ajax({
            url: 'plugin/com.suncode.plugin-vendor.checker/api/check/iban',
            type: 'POST',
            data: {
                nip: nip,
                iban: iban,
                date: date ? date.dateFormat('Y-m-d') : null,
                processid: processId
            },
            success: function (result) {
                var msg = result.message;
                var valid = false;
                if (result.success) {
                    msg = VENDOR.t(result.commentKey, result.commentValue, result.commentIban);
                   if(addRequestId){
                	   msg+=" "+VENDOR.t('comment.requestID',result.reuestId);
                   }
                }
                if (statusVar) {
                    VariableService.setValue(statusVar.getId(), result.message);
                } else {
                    valid = (result.message == "TAK") || (result.message == "TAK - Konto wirtualne") ? true : false;
                    if (valid) {
                        MessageService.showSuccess(msg);
                    } else {
                        MessageService.showFailure(msg);
                    }
                }
                if (isOnComment) {
                    CommentService.add(msg); 
                }
                if (requestIdVar) {
                    VariableService.setValue(requestIdVar.getId(), result.reuestId);
                }
                FormService.unmask();
                return true;
            },
            error: function () {
                FormService.unmask();
                MessageService.showFailure(VENDOR.t('server.error'));
                return false;
            }
        });
    }
});