/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.vendor.checker.utils;

import com.suncode.plugin.vendor.checker.enums.EntityParams;
import com.suncode.plugin.vendor.checker.schemas.Entity;
import com.suncode.plugin.vendor.checker.schemas.EntityPerson;
import com.suncode.plugin.vendor.checker.utils.DateStringConverter;

public class EntityTransformer {
    public static Object readParam(Entity entity, EntityParams pram, Boolean dateAsString) {
        switch (pram) {
            case ACCOUNT_NUMBERS: {
                return entity.getAccountNumbers();
            }
            case AUTHORIZED_CLERKS_COMPANY_NAME: {
                return EntityTransformer.getEntityPersonValues(entity.getAuthorizedClerks(), PersonParam.COMPANY);
            }
            case AUTHORIZED_CLERKS_FIRST_NAME: {
                return EntityTransformer.getEntityPersonValues(entity.getAuthorizedClerks(), PersonParam.FIRSTNAME);
            }
            case AUTHORIZED_CLERKS_LAST_NAME: {
                return EntityTransformer.getEntityPersonValues(entity.getAuthorizedClerks(), PersonParam.LASTNAME);
            }
            case AUTHORIZED_CLERKS_NIP: {
                return EntityTransformer.getEntityPersonValues(entity.getAuthorizedClerks(), PersonParam.NIP);
            }
            case AUTHORIZED_CLERKS_PESEL: {
                return EntityTransformer.getEntityPersonValues(entity.getAuthorizedClerks(), PersonParam.PESEL);
            }
            case HAS_VIRTUAL_ACCOUNTS: {
                return entity.getHasVirtualAccounts();
            }
            case KRS: {
                return entity.getKrs();
            }
            case NAME: {
                return entity.getName();
            }
            case NIP: {
                return entity.getNip();
            }
            case PARTNERS_COMPANY_NAME: {
                return EntityTransformer.getEntityPersonValues(entity.getPartners(), PersonParam.COMPANY);
            }
            case PARTNERS_FIRST_NAME: {
                return EntityTransformer.getEntityPersonValues(entity.getPartners(), PersonParam.FIRSTNAME);
            }
            case PARTNERS_LAST_NAME: {
                return EntityTransformer.getEntityPersonValues(entity.getPartners(), PersonParam.LASTNAME);
            }
            case PARTNERS_NIP: {
                return EntityTransformer.getEntityPersonValues(entity.getPartners(), PersonParam.NIP);
            }
            case PARTNERS_PESEL: {
                return EntityTransformer.getEntityPersonValues(entity.getPartners(), PersonParam.PESEL);
            }
            case PESEL: {
                return entity.getPesel();
            }
            case REGISTRATION_DENIAL_BASIS: {
                return entity.getRegistrationDenialBasis();
            }
            case REGISTRATION_DENIAL_DATE: {
                return dateAsString != false ? entity.getRegistrationDenialDate() : DateStringConverter.stringToDate(entity.getRegistrationDenialDate());
            }
            case REGISTRATION_LEGAL_DATE: {
                return dateAsString != false ? entity.getRegistrationLegalDate() : DateStringConverter.stringToDate(entity.getRegistrationLegalDate());
            }
            case REGON: {
                return entity.getRegon();
            }
            case REMOVAL_BASIS: {
                return entity.getRemovalBasis();
            }
            case REMOVAL_DATE: {
                return dateAsString != false ? entity.getRemovalDate() : DateStringConverter.stringToDate(entity.getRemovalDate());
            }
            case REPRESENTATIVES_COMPANY_NAME: {
                return EntityTransformer.getEntityPersonValues(entity.getRepresentatives(), PersonParam.COMPANY);
            }
            case REPRESENTATIVES_FIRST_NAME: {
                return EntityTransformer.getEntityPersonValues(entity.getRepresentatives(), PersonParam.FIRSTNAME);
            }
            case REPRESENTATIVES_LAST_NAME: {
                return EntityTransformer.getEntityPersonValues(entity.getRepresentatives(), PersonParam.LASTNAME);
            }
            case REPRESENTATIVES_NIP: {
                return EntityTransformer.getEntityPersonValues(entity.getRepresentatives(), PersonParam.NIP);
            }
            case REPRESENTATIVES_PESEL: {
                return EntityTransformer.getEntityPersonValues(entity.getRepresentatives(), PersonParam.PESEL);
            }
            case RESIDENCE_ADDRESS: {
                return entity.getResidenceAddress();
            }
            case RESTORATION_DATE: {
                return dateAsString != false ? entity.getRestorationDate() : DateStringConverter.stringToDate(entity.getRestorationDate());
            }
            case RESTORATION_BASIS: {
                return entity.getRestorationBasis();
            }
            case STATUS_VAT: {
                return entity.getStatusVat();
            }
            case WORKING_ADRESS: {
                return entity.getWorkingAddress();
            }
        }
        return null;
    }

    private static Object getEntityPersonValues(EntityPerson[] entityPersons, PersonParam param) {
        if (entityPersons != null) {
            String[] values = new String[entityPersons.length];
            for (int i = 0; i < entityPersons.length; ++i) {
                values[i] = EntityTransformer.getEntityPersonValue(entityPersons[i], param);
            }
            return values;
        }
        return null;
    }

    private static String getEntityPersonValue(EntityPerson entityPerson, PersonParam param) {
        switch (param) {
            case COMPANY: {
                return entityPerson.getCompanyName();
            }
            case FIRSTNAME: {
                return entityPerson.getFirstName();
            }
            case LASTNAME: {
                return entityPerson.getLastName();
            }
            case NIP: {
                return entityPerson.getNip();
            }
            case PESEL: {
                return entityPerson.getPesel();
            }
        }
        return null;
    }

    private static enum PersonParam {
        COMPANY,
        FIRSTNAME,
        LASTNAME,
        PESEL,
        NIP;

    }
}

