/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.vendor.checker.utils;

import com.google.gson.Gson;
import com.suncode.plugin.vendor.checker.enums.CheckMessageResponse;
import com.suncode.plugin.vendor.checker.enums.SearchType;
import com.suncode.plugin.vendor.checker.schemas.CheckDto;
import com.suncode.plugin.vendor.checker.schemas.Entity;
import com.suncode.plugin.vendor.checker.schemas.EntityCheckResponse;
import com.suncode.plugin.vendor.checker.schemas.EntityItem;
import com.suncode.plugin.vendor.checker.schemas.Entry;
import com.suncode.plugin.vendor.checker.schemas.FlatFileDto;
import com.suncode.plugin.vendor.checker.schemas.ParamData;
import com.suncode.plugin.vendor.checker.schemas.ResponseData;
import com.suncode.plugin.vendor.checker.schemas.ResponseEntities;
import com.suncode.pwfl.workflow.WorkflowContext;
import com.suncode.pwfl.workflow.process.Comment;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class Builder {
    public static FlatFileDto buildFlatFileDto(File file) throws FileNotFoundException {
        InputStreamReader reader = new InputStreamReader(new FileInputStream(file));
        Gson gson = new Gson();
        return (FlatFileDto)gson.fromJson((Reader)reader, FlatFileDto.class);
    }

    public static ParamData buildParamData(String[] nipsRegons, String[] ibans, String[] dates, int i) {
        String value = null;
        ParamData paramData = new ParamData();
        value = ibans.length == 1 ? ibans[0] : (i < ibans.length ? ibans[i] : null);
        paramData.setNrb(value);
        value = nipsRegons.length == 1 ? nipsRegons[0] : (i < nipsRegons.length ? nipsRegons[i] : null);
        paramData.setNip(value);
        String dateParam = null;
        dateParam = dates.length == 1 ? dates[0] : (i < dates.length ? dates[i] : null);
        paramData.setDate(dateParam);
        return paramData;
    }

    public static ParamData buildParamData(String[] nipsRegons, String[] ibans, LocalDate[] dates, int i) {
        String value = null;
        ParamData paramData = new ParamData();
        value = ibans.length == 1 ? ibans[0] : (i < ibans.length ? ibans[i] : null);
        paramData.setNrb(value);
        value = nipsRegons.length == 1 ? nipsRegons[0] : (i < nipsRegons.length ? nipsRegons[i] : null);
        paramData.setNip(value);
        LocalDate dateParam = null;
        dateParam = dates.length == 1 ? dates[0] : (i < dates.length ? dates[i] : null);
        paramData.setDate(dateParam);
        return paramData;
    }

    public static CheckDto buildCheckDto(ParamData paramData, String msg) {
        CheckDto checkDto = new CheckDto();
        checkDto.setMessage(Builder.replaceSemicolon(msg));
        checkDto.setSuccess(false);
        checkDto.setReuestId("");
        return checkDto;
    }

    public static CheckDto buildCheckDto(ParamData paramData, ResponseData<EntityCheckResponse> resultOnline) {
        CheckDto checkDto = new CheckDto();
        checkDto.setMessage(Builder.replaceSemicolon(resultOnline.getMessage()));
        checkDto.setCommentIban(paramData.getNrb());
        checkDto.setSuccess(resultOnline.getSuccess());
        if (resultOnline.getSuccess().booleanValue()) {
            checkDto.setReuestId(resultOnline.getData().getResult().getRequestId());
            Builder.setCommentTranslate(paramData, checkDto, resultOnline.getMessage());
        } else {
            checkDto.setReuestId("");
        }
        return checkDto;
    }

    private static String replaceSemicolon(String message) {
        return StringUtils.isNotBlank((CharSequence)message) ? message.replace(";", ",") : message;
    }

    private static void setCommentTranslate(ParamData paramData, CheckDto checkDto, String message) {
        if (message.equalsIgnoreCase(CheckMessageResponse.NO_IBAN.getMsg())) {
            checkDto.setCommentKey("comment.valid.iban.false");
            checkDto.setCommentValue(paramData.getNrb());
        } else if (message.equalsIgnoreCase(CheckMessageResponse.YES.getMsg())) {
            checkDto.setCommentKey("comment.valid.nip.true");
            checkDto.setCommentValue(paramData.getNip());
        } else if (message.equalsIgnoreCase(CheckMessageResponse.YES_VIRTUAL.getMsg())) {
            checkDto.setCommentKey("comment.valid.virtual.nip.true");
            checkDto.setCommentValue(paramData.getNip());
        } else if (message.equalsIgnoreCase(CheckMessageResponse.NO.getMsg())) {
            checkDto.setCommentKey("comment.valid.nip.false");
            checkDto.setCommentValue(paramData.getNip());
        } else {
            checkDto.setCommentKey(message);
        }
    }

    public static ParamData buildParamData(String nipOrNrb, LocalDate date, String searchType) {
        ParamData param = new ParamData();
        SearchType type = SearchType.valueOf(searchType);
        param.setSearchType(type);
        switch (type) {
            case NIP: {
                param.setNip(nipOrNrb);
                break;
            }
            case NRB: {
                param.setNrb(nipOrNrb);
                break;
            }
        }
        param.setDate(date);
        return param;
    }

    public static Comment buildComment(String msg, WorkflowContext context, String userName) {
        if (msg.length() > 3900) {
            msg = msg.substring(0, 3900) + "...";
        }
        Comment comment = new Comment();
        comment.setComment(msg);
        comment.setActivityId(context.getActivityId());
        comment.setProcessId(context.getProcessId());
        comment.setTimestamp(Long.valueOf(DateTime.now().getMillis()));
        comment.setUserId(StringUtils.isBlank((CharSequence)userName) ? "admin" : userName);
        return comment;
    }

    public static List<ParamData> buildParamDatas(String[] nipsRegons, String[] ibans, String[] dates) {
        int maxLength = Builder.maxLength(nipsRegons, ibans, dates);
        ArrayList<ParamData> paramsInput = new ArrayList<ParamData>();
        for (int i = 0; i < maxLength; ++i) {
            ParamData paramData = Builder.buildParamData(nipsRegons, ibans, dates, i);
            paramsInput.add(paramData);
        }
        return paramsInput;
    }

    public static List<ParamData> buildParamDatas(String[] nipsRegons, String[] ibans, LocalDate[] dates) {
        int maxLength = Builder.maxLength(nipsRegons, ibans, dates);
        ArrayList<ParamData> paramsInput = new ArrayList<ParamData>();
        for (int i = 0; i < maxLength; ++i) {
            ParamData paramData = Builder.buildParamData(nipsRegons, ibans, dates, i);
            paramsInput.add(paramData);
        }
        return paramsInput;
    }

    public static List<ParamData> buildMultiParamData(List<String> nipsOrNrbs, LocalDate date, String searchType) {
        ArrayList<ParamData> paramsData = new ArrayList<ParamData>();
        int count = 0;
        ParamData paramData = new ParamData();
        for (String nipOrNrb : nipsOrNrbs) {
            if (!StringUtils.isNotBlank((CharSequence)nipOrNrb)) continue;
            SearchType type = SearchType.valueOf(searchType);
            paramData.setSearchType(type);
            switch (type) {
                case NIPS: {
                    paramData.addNIPs(nipOrNrb);
                    break;
                }
                case NRBS: {
                    paramData.addNRB(nipOrNrb);
                    break;
                }
            }
            paramData.setDate(date);
            if (++count != 30) continue;
            paramsData.add(paramData);
            count = 0;
            paramData = new ParamData();
        }
        if (count > 0) {
            paramsData.add(paramData);
        }
        return paramsData;
    }

    public static List<ParamData> buildMultiParamData(String[] nipsOrNrbs, LocalDate[] dates, String searchType) {
        Map<LocalDate, List<String>> segregateByDates = Builder.sortByDate(nipsOrNrbs, dates);
        return segregateByDates.entrySet().stream().map(entry -> Builder.buildMultiParamData((List)entry.getValue(), (LocalDate)entry.getKey(), searchType)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static Map<LocalDate, List<String>> sortByDate(String[] nipsOrNrbs, LocalDate[] dates) {
        HashMap<LocalDate, List<String>> segregateByDates = new HashMap<LocalDate, List<String>>();
        for (int index = 0; index < nipsOrNrbs.length; ++index) {
            LocalDate date = Builder.readDate(index, dates);
            if (!segregateByDates.containsKey(date)) {
                segregateByDates.put(date, new ArrayList());
            }
            ((List)segregateByDates.get(date)).add(nipsOrNrbs[index]);
        }
        return segregateByDates;
    }

    public static LocalDate readDate(int index, LocalDate[] dates) {
        if (dates == null || index >= dates.length || dates[index] == null) {
            return DateTime.now().toLocalDate();
        }
        return dates[index];
    }

    public static EntityItem buildEntityItem(ResponseEntities response, Entity entity) {
        return EntityItem.builder().subject(entity).requestDateTime(response.getRequestDateTime()).requestId(response.getRequestId()).build();
    }

    public static EntityItem buildEntityItem(ResponseEntities response, Entry entry) {
        return EntityItem.builder().errorMessege(entry.getErrorMsg()).requestDateTime(response.getRequestDateTime()).requestId(response.getRequestId()).subject(entry.getFirstSubject()).build();
    }

    private static int maxLength(Object[] nipsRegons, Object[] ibans, Object[] dates) {
        int maxLength = nipsRegons.length;
        if (ibans.length > maxLength) {
            maxLength = ibans.length;
        }
        if (dates.length > maxLength) {
            maxLength = dates.length;
        }
        return maxLength;
    }
}

