/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.vendor.checker.servlets;

import com.suncode.plugin.vendor.checker.enums.EntityHeaderParams;
import com.suncode.plugin.vendor.checker.enums.EntityParam;
import com.suncode.plugin.vendor.checker.enums.EntityParams;
import com.suncode.plugin.vendor.checker.schemas.EntityParamDto;
import com.suncode.pwfl.search.CountedResult;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"dpwe"})
public class DpweController {
    @RequestMapping(value={"entityparams"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<EntityParamDto> getEntityParams(@RequestParam String query, @RequestParam String start, @RequestParam String limit) {
        return this.getEntityParamsCounted(query, start, limit, EntityParams.values());
    }

    @RequestMapping(value={"entityheaderparams"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<EntityParamDto> getEntityHeaderParams(@RequestParam String query, @RequestParam String start, @RequestParam String limit) {
        return this.getEntityParamsCounted(query, start, limit, EntityHeaderParams.values());
    }

    @RequestMapping(value={"entitytypes"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, String> getEntityTypes() {
        return Arrays.stream(EntityParams.values()).collect(Collectors.toMap(Enum::name, EntityParams::getType));
    }

    @RequestMapping(value={"entityheadertypes"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, String> getEntityHeaderTypes() {
        return Arrays.stream(EntityHeaderParams.values()).collect(Collectors.toMap(Enum::name, EntityHeaderParams::getType));
    }

    private CountedResult<EntityParamDto> getEntityParamsCounted(String query, String start, String limit, EntityParam[] enumList) {
        CountedResult countedResult = new CountedResult();
        List resultList = Arrays.stream(enumList).map(item -> item.build()).filter(entityParam -> this.nameOrDisplayNameMatch(query, (EntityParamDto)entityParam)).collect(Collectors.toList());
        int total = resultList.size();
        int startValue = Long.valueOf(start).intValue();
        int limitValue = Long.valueOf(limit).intValue();
        if (total > limitValue) {
            countedResult.setData(resultList.subList(startValue, Math.min(startValue + limitValue - 1, resultList.size())));
        } else {
            countedResult.setData(resultList);
        }
        countedResult.setTotal((long)total);
        return countedResult;
    }

    private boolean nameOrDisplayNameMatch(String query, EntityParamDto entityParam) {
        return StringUtils.isBlank((CharSequence)query) || entityParam.getName().toLowerCase().contains(query.toLowerCase()) || entityParam.getDisplayName().toLowerCase().contains(query.toLowerCase());
    }
}

