/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.vendor.checker.services;

import com.suncode.plugin.vendor.checker.entity.VendorLogEntity;
import com.suncode.plugin.vendor.checker.entity.VendorLog_Dao;
import com.suncode.plugin.vendor.checker.enums.VendorSource;
import com.suncode.plugin.vendor.checker.services.VendorLogService;
import com.suncode.pwfl.util.EditableServiceImpl;
import java.sql.Timestamp;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class VendorLogServiceImpl
extends EditableServiceImpl<VendorLogEntity, Long, VendorLog_Dao>
implements VendorLogService {
    private static final Logger log = LoggerFactory.getLogger(VendorLogServiceImpl.class);

    @Autowired
    public void setDao(VendorLog_Dao dao) {
        this.dao = dao;
    }

    @Override
    public void save(DateTime dateTime, String status, VendorSource source, String info) {
        VendorLogEntity entity = this.buildEntity(dateTime, status, source.name(), info, null);
        this.saveWithIgnoreException(entity);
    }

    @Override
    public void save(DateTime dateTime, String status, VendorSource source, String info, int httpStatusCode) {
        VendorLogEntity entity = this.buildEntity(dateTime, status, source.name(), info, new Long(httpStatusCode));
        this.saveWithIgnoreException(entity);
    }

    private void saveWithIgnoreException(VendorLogEntity entity) {
        try {
            ((VendorLog_Dao)this.dao).save(entity);
        }
        catch (Exception e) {
            log.info(" Error while save log to pm_vendor_log SKIP");
            log.error("Error while save log to pm_vendor_logwith params " + entity, (Throwable)e);
        }
    }

    private VendorLogEntity buildEntity(DateTime dateTime, String status, String source, String info, Long httpStatusCode) {
        VendorLogEntity entity = new VendorLogEntity();
        entity.setSource(source);
        entity.setStatus(status.substring(0, Math.min(status.length(), 4000)));
        entity.setInfo(info.substring(0, Math.min(info.length(), 4000)));
        entity.setCheckDate(new Timestamp(dateTime.getMillis()));
        entity.setHttpStatusCode(httpStatusCode);
        return entity;
    }
}

