/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.vendor.checker.services;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.suncode.plugin.vendor.checker.engine.SearchBankAccountEngine;
import com.suncode.plugin.vendor.checker.engine.SearchNipEngine;
import com.suncode.plugin.vendor.checker.enums.SearchType;
import com.suncode.plugin.vendor.checker.enums.VendorSource;
import com.suncode.plugin.vendor.checker.exception.ConnectionException;
import com.suncode.plugin.vendor.checker.exception.ResponseException;
import com.suncode.plugin.vendor.checker.schemas.Entity;
import com.suncode.plugin.vendor.checker.schemas.EntityItem;
import com.suncode.plugin.vendor.checker.schemas.EntityListResponse;
import com.suncode.plugin.vendor.checker.schemas.EntityResponse;
import com.suncode.plugin.vendor.checker.schemas.Entry;
import com.suncode.plugin.vendor.checker.schemas.EntryListResponse;
import com.suncode.plugin.vendor.checker.schemas.ParamData;
import com.suncode.plugin.vendor.checker.schemas.ResponseData;
import com.suncode.plugin.vendor.checker.schemas.ResponseEntities;
import com.suncode.plugin.vendor.checker.schemas.ResponseEntityDto;
import com.suncode.plugin.vendor.checker.services.EntitiesInfoService;
import com.suncode.plugin.vendor.checker.services.VendorLogService;
import com.suncode.plugin.vendor.checker.utils.Builder;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EntityInfoServiceImpl
implements EntitiesInfoService {
    private static final Logger log = LoggerFactory.getLogger(EntityInfoServiceImpl.class);
    @Autowired
    private SearchNipEngine searchNipEng;
    @Autowired
    private SearchBankAccountEngine searchBankAccountEng;
    private final LoadingCache<ParamData, ResponseEntities> empCache = CacheBuilder.newBuilder().maximumSize(8000L).expireAfterWrite(1L, TimeUnit.DAYS).build((CacheLoader)new CacheLoader<ParamData, ResponseEntities>(){

        public ResponseEntities load(ParamData param) throws ResponseException, IOException {
            ResponseEntities response = new ResponseEntities();
            switch (param.getSearchType()) {
                case NIP: {
                    ResponseData<EntityResponse> responseNipData = EntityInfoServiceImpl.this.searchNipEng.searchNip(param);
                    response.addEntity(responseNipData.getData().getResult().getSubject());
                    response.setRequestId(responseNipData.getData().getResult().getRequestId());
                    response.setRequestDateTime(responseNipData.getData().getResult().getRequestDateTime());
                    response.setSuccess(responseNipData.getSuccess());
                    response.setMessage(responseNipData.getMessage());
                    break;
                }
                case NRB: {
                    ResponseData<EntityListResponse> responseBankData = EntityInfoServiceImpl.this.searchBankAccountEng.searchBankAccount(param);
                    Entity[] subjects = responseBankData.getData().getResult().getSubjects();
                    if (subjects != null && subjects.length > 0) {
                        response.addEntity(subjects[0]);
                        response.setMessage(responseBankData.getMessage());
                        response.setTotalEntities(1);
                    }
                    this.setResponseDataParam(response, responseBankData.getSuccess(), responseBankData.getData().getResult().getRequestId(), responseBankData.getData().getResult().getRequestDateTime());
                    break;
                }
                case NIPS: {
                    ResponseData<EntryListResponse> responseNipsData = EntityInfoServiceImpl.this.searchNipEng.searchNips(param);
                    response.addEntries(responseNipsData.getData().getResult().getEntries());
                    response.setMessage(responseNipsData.getMessage());
                    this.setResponseDataParam(response, responseNipsData.getSuccess(), responseNipsData.getData().getResult().getRequestId(), responseNipsData.getData().getResult().getRequestDateTime());
                    break;
                }
                case NRBS: {
                    ResponseData<EntryListResponse> responseNrbsData = EntityInfoServiceImpl.this.searchBankAccountEng.searchBankAccounts(param);
                    response.addEntries(responseNrbsData.getData().getResult().getEntries());
                    response.setMessage(responseNrbsData.getMessage());
                    this.setResponseDataParam(response, responseNrbsData.getSuccess(), responseNrbsData.getData().getResult().getRequestId(), responseNrbsData.getData().getResult().getRequestDateTime());
                    break;
                }
                default: {
                    log.debug("Wrong search type : " + (Object)((Object)param.getSearchType()));
                }
            }
            return response;
        }

        private void setResponseDataParam(ResponseEntities response, Boolean success, String requestId, String requestDateTime) {
            response.setSuccess(success);
            response.setRequestId(requestId);
            response.setRequestDateTime(requestDateTime);
        }
    });
    @Autowired
    private VendorLogService vendorLogService;

    @Override
    public ResponseEntities getEntities(ParamData param) throws ConnectionException {
        ResponseEntities response = new ResponseEntities();
        try {
            log.debug("Get data from cache");
            this.logVendor(param);
            response = (ResponseEntities)this.empCache.get((Object)param);
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof ResponseException) {
                ResponseException re = (ResponseException)ee.getCause();
                log.debug("Don 't save to cache");
                response.setMessage(re.getMessage());
                log.debug(ResponseException.class.getSimpleName() + ":" + re.getMessage());
            }
            throw new ConnectionException(ee);
        }
        return response;
    }

    @Override
    public ResponseEntityDto getResponseEntityDto(List<ParamData> paramsData) throws ConnectionException {
        ResponseEntityDto responseEntityDto = new ResponseEntityDto(true);
        StringBuilder errorMessage = new StringBuilder();
        for (ParamData paramData : paramsData) {
            ResponseEntities response = this.getEntities(paramData);
            if (response.getSuccess().booleanValue()) {
                for (Entry entry : response.getEntry()) {
                    EntityItem entityItem = Builder.buildEntityItem(response, entry);
                    if (entityItem.isError().booleanValue()) {
                        responseEntityDto.setSuccess(false);
                        errorMessage.append(entityItem.getErrorMessege()).append(", ");
                    }
                    responseEntityDto.putToEntityItemMap(entry.getIdentifier() + "##" + paramData.getDate().toString(), entityItem);
                }
                continue;
            }
            responseEntityDto.setSuccess(false);
            if (!StringUtils.isNotBlank((CharSequence)response.getMessage())) continue;
            errorMessage.append(response.getMessage()).append(", ");
        }
        responseEntityDto.setErrorMessage(errorMessage.toString());
        return responseEntityDto;
    }

    private void logVendor(ParamData param) {
        ResponseEntities response = (ResponseEntities)this.empCache.getIfPresent((Object)param);
        if (response != null) {
            String info = this.buildInfo(param);
            String status = response.getMessage();
            this.vendorLogService.save(DateTime.now(), status, VendorSource.CACHE, info);
        }
    }

    private String buildInfo(ParamData param) {
        StringBuilder sb = new StringBuilder();
        SearchType searchType = param.getSearchType();
        if (searchType == SearchType.NIP || searchType == SearchType.NRB) {
            sb.append("DATA:\t").append(" NIP: ").append(param.getSanitizedNIP()).append("\t").append(" NRB: ").append(param.getSanitizedNRB()).append("\t").append(" DATE: ").append(param.getDate()).append("\t");
        } else if (searchType == SearchType.NIPS || searchType == SearchType.NRBS) {
            sb.append("DATA:\t").append(" NIPS: ").append(param.getSanitizedNIPs()).append("\t").append(" NRBS: ").append(param.getSanitizedNRBs()).append("\t").append(" DATE: ").append(param.getDate()).append("\t");
        }
        return sb.toString();
    }
}

