/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.vendor.checker.schemas;

import com.google.common.base.Objects;
import com.suncode.plugin.vendor.checker.enums.SearchType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class ParamData
implements Serializable {
    private static final long serialVersionUID = 20200330L;
    private String nip;
    private String nrb;
    private LocalDate date;
    private List<String> nips = new ArrayList<String>();
    private List<String> nrbs = new ArrayList<String>();
    private SearchType searchType;

    public void setDate(LocalDate date) {
        this.date = date == null ? DateTime.now().toLocalDate() : date;
    }

    public void setDate(String date) {
        if (StringUtils.isBlank((CharSequence)date)) {
            this.date = DateTime.now().toLocalDate();
        } else {
            DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
            this.date = formatter.parseDateTime(date).toLocalDate();
        }
    }

    public void addNIPs(String nip) {
        this.nips.add(nip);
    }

    public void addNRB(String nrb) {
        this.nrbs.add(nrb);
    }

    public String getSanitizedNRB() {
        return this.sanitize(this.nrb);
    }

    public String getSanitizedNIP() {
        return this.sanitize(this.nip);
    }

    public String getNIPS() {
        return this.nips.stream().limit(30L).collect(Collectors.joining(","));
    }

    public String getSanitizedNIPs() {
        return this.nips.stream().limit(30L).map(nip -> this.sanitize((String)nip)).collect(Collectors.joining(","));
    }

    public String getNRBs() {
        return this.nrbs.stream().limit(30L).collect(Collectors.joining(","));
    }

    public String getSanitizedNRBs() {
        return this.nrbs.stream().limit(30L).map(nrb -> this.sanitize((String)nrb)).collect(Collectors.joining(","));
    }

    private String sanitize(String string) {
        return StringUtils.isBlank((CharSequence)string) ? "" : string.replaceAll("\\D", "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParamData)) {
            return false;
        }
        ParamData paramData = (ParamData)o;
        return Objects.equal((Object)this.nip, (Object)paramData.nip) && Objects.equal((Object)this.nrb, (Object)paramData.nrb) && Objects.equal((Object)this.date, (Object)paramData.date) && Objects.equal(this.nips, paramData.nips) && Objects.equal(this.nrbs, paramData.nrbs) && this.searchType == paramData.searchType;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.nip, this.nrb, this.date, this.nips, this.nrbs, this.searchType});
    }

    public String getNip() {
        return this.nip;
    }

    public String getNrb() {
        return this.nrb;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public SearchType getSearchType() {
        return this.searchType;
    }

    public void setNip(String nip) {
        this.nip = nip;
    }

    public void setNrb(String nrb) {
        this.nrb = nrb;
    }

    public void setNips(List<String> nips) {
        this.nips = nips;
    }

    public void setNrbs(List<String> nrbs) {
        this.nrbs = nrbs;
    }

    public void setSearchType(SearchType searchType) {
        this.searchType = searchType;
    }

    public String toString() {
        return "ParamData(nip=" + this.getNip() + ", nrb=" + this.getNrb() + ", date=" + this.getDate() + ", nips=" + this.getNIPS() + ", nrbs=" + this.getNRBs() + ", searchType=" + (Object)((Object)this.getSearchType()) + ")";
    }
}

