/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.vendor.checker.schemas;

import com.suncode.plugin.vendor.checker.schemas.Entity;
import com.suncode.plugin.vendor.checker.schemas.EntityException;
import java.beans.ConstructorProperties;
import java.util.Arrays;

public class Entry {
    String identifier;
    Entity[] subjects;
    EntityException error;

    public Boolean isError() {
        return this.error != null;
    }

    public String getErrorMsg() {
        if (this.isError().booleanValue()) {
            return this.error.getMessage();
        }
        return "";
    }

    public Entity getFirstSubject() {
        if (this.isError().booleanValue() || this.subjects.length < 0) {
            return null;
        }
        return this.subjects[0];
    }

    public static EntryBuilder builder() {
        return new EntryBuilder();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Entity[] getSubjects() {
        return this.subjects;
    }

    public EntityException getError() {
        return this.error;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setSubjects(Entity[] subjects) {
        this.subjects = subjects;
    }

    public void setError(EntityException error) {
        this.error = error;
    }

    public String toString() {
        return "Entry(identifier=" + this.getIdentifier() + ", subjects=" + Arrays.deepToString(this.getSubjects()) + ", error=" + this.getError() + ")";
    }

    public Entry() {
    }

    @ConstructorProperties(value={"identifier", "subjects", "error"})
    public Entry(String identifier, Entity[] subjects, EntityException error) {
        this.identifier = identifier;
        this.subjects = subjects;
        this.error = error;
    }

    public static class EntryBuilder {
        private String identifier;
        private Entity[] subjects;
        private EntityException error;

        EntryBuilder() {
        }

        public EntryBuilder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public EntryBuilder subjects(Entity[] subjects) {
            this.subjects = subjects;
            return this;
        }

        public EntryBuilder error(EntityException error) {
            this.error = error;
            return this;
        }

        public Entry build() {
            return new Entry(this.identifier, this.subjects, this.error);
        }

        public String toString() {
            return "Entry.EntryBuilder(identifier=" + this.identifier + ", subjects=" + Arrays.deepToString(this.subjects) + ", error=" + this.error + ")";
        }
    }
}

