/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.vendor.checker.engine;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.gson.Gson;
import com.suncode.plugin.vendor.checker.enums.ApiMethod;
import com.suncode.plugin.vendor.checker.enums.CheckMessageResponse;
import com.suncode.plugin.vendor.checker.enums.SystemParametersKey;
import com.suncode.plugin.vendor.checker.enums.VendorSource;
import com.suncode.plugin.vendor.checker.exception.ResponseException;
import com.suncode.plugin.vendor.checker.schemas.Entity;
import com.suncode.plugin.vendor.checker.schemas.EntityException;
import com.suncode.plugin.vendor.checker.schemas.EntityListResponse;
import com.suncode.plugin.vendor.checker.schemas.Entry;
import com.suncode.plugin.vendor.checker.schemas.EntryListResponse;
import com.suncode.plugin.vendor.checker.schemas.ParamData;
import com.suncode.plugin.vendor.checker.schemas.ResponseData;
import com.suncode.plugin.vendor.checker.services.VendorLogService;
import com.suncode.plugin.vendor.checker.utils.NetTools;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchBankAccountEngine {
    private static final Logger log = LoggerFactory.getLogger(SearchBankAccountEngine.class);
    @Autowired
    private VendorLogService vendorLogService;

    public ResponseData<EntityListResponse> searchBankAccount(ParamData param) throws IOException, ResponseException {
        String hostUrl = SystemProperties.getString((String)SystemParametersKey.SERWER_HOST.getName());
        if (StringUtils.isBlank((CharSequence)hostUrl)) {
            throw new RuntimeException("Not set parameter " + SystemParametersKey.SERWER_HOST.getName());
        }
        String method = "/api/search/bank-account/" + param.getSanitizedNRB();
        String url = hostUrl + method;
        GenericUrl genericUrl = new GenericUrl(url);
        genericUrl.put("date", (Object)param.getDate().toString());
        return this.executeSearchBankAccount(genericUrl, param);
    }

    public ResponseData<EntryListResponse> searchBankAccounts(ParamData param) throws IOException, ResponseException {
        String hostUrl = SystemProperties.getString((String)SystemParametersKey.SERWER_HOST.getName());
        if (StringUtils.isBlank((CharSequence)hostUrl)) {
            throw new RuntimeException("Not set parameter " + SystemParametersKey.SERWER_HOST.getName());
        }
        String apiResource = "/api/search/bank-accounts/" + param.getSanitizedNRBs();
        String url = hostUrl + apiResource;
        GenericUrl genericUrl = new GenericUrl(url);
        genericUrl.put("date", (Object)param.getDate().toString());
        return this.executeSearchBankAccounts(genericUrl, param);
    }

    private void buildMessage(ParamData param, ResponseData<EntityListResponse> responseData) {
        Entity[] subjects = responseData.getData().getResult().getSubjects();
        if (subjects == null || subjects.length == 0) {
            responseData.setMessage(CheckMessageResponse.NO_IBAN.getMsg());
        } else {
            for (Entity subject : subjects) {
                if (!subject.getNip().equals(param.getNip())) continue;
                responseData.setMessage(CheckMessageResponse.YES_VIRTUAL.getMsg());
                return;
            }
            responseData.setMessage(CheckMessageResponse.NO.getMsg());
        }
    }

    private ResponseData<EntryListResponse> executeSearchBankAccounts(GenericUrl genericUrl, ParamData param) throws IOException, ResponseException {
        Gson gson = new Gson();
        try {
            HttpRequestFactory requestFactory = new NetHttpTransport().createRequestFactory();
            HttpRequest requestGET = requestFactory.buildGetRequest(genericUrl);
            log.debug("REQUEST URL\t" + requestGET.getUrl().build());
            HttpResponse response = requestGET.execute();
            int statusCode = response.getStatusCode();
            log.debug("StatusCode " + statusCode);
            String responseJSON = NetTools.readContent(response.getContent());
            log.debug(responseJSON);
            EntryListResponse entityListResponse = (EntryListResponse)gson.fromJson(responseJSON, EntryListResponse.class);
            ResponseData<EntryListResponse> responseData = new ResponseData<EntryListResponse>();
            responseData.setSuccess(true);
            responseData.setData(entityListResponse);
            responseData.setMessage(this.buildMessage(entityListResponse.getResult().getEntries()));
            responseData.setMethod(ApiMethod.SEARCH_BANK);
            this.logVendor(genericUrl.build(), statusCode, responseData.getMessage());
            return responseData;
        }
        catch (HttpResponseException httpException) {
            log.debug("HttpResponseException");
            log.debug("StatusCode: ", (Object)httpException.getStatusCode());
            log.debug("Content: ", (Object)httpException.getContent());
            if (httpException.getStatusCode() == 400 || httpException.getStatusCode() == 420 || httpException.getStatusCode() == 429) {
                EntityException entityException = (EntityException)gson.fromJson(httpException.getContent(), EntityException.class);
                ResponseException re = new ResponseException(entityException.getMessage(), entityException);
                this.logVendor(genericUrl.build(), httpException.getStatusCode(), entityException.getMessage());
                throw re;
            }
            this.logVendor(genericUrl.build(), httpException.getStatusCode(), httpException.getContent());
            throw httpException;
        }
    }

    private String buildMessage(Entry[] entry) {
        long count = Arrays.asList(entry).stream().filter(item -> item.getSubjects() != null).count();
        return "Finded " + count + "entities";
    }

    private ResponseData<EntityListResponse> executeSearchBankAccount(GenericUrl genericUrl, ParamData param) throws IOException, ResponseException {
        Gson gson = new Gson();
        try {
            HttpRequestFactory requestFactory = new NetHttpTransport().createRequestFactory();
            HttpRequest requestGET = requestFactory.buildGetRequest(genericUrl);
            log.debug("REQUEST URL\t" + requestGET.getUrl().build());
            HttpResponse response = requestGET.execute();
            int statusCode = response.getStatusCode();
            log.debug("StatusCode " + statusCode);
            String responseJSON = NetTools.readContent(response.getContent());
            log.debug(responseJSON);
            EntityListResponse entityListResponse = (EntityListResponse)gson.fromJson(responseJSON, EntityListResponse.class);
            ResponseData<EntityListResponse> responseData = new ResponseData<EntityListResponse>();
            responseData.setSuccess(true);
            responseData.setData(entityListResponse);
            responseData.setMessage(this.buildStatus(entityListResponse));
            responseData.setMethod(ApiMethod.SEARCH_BANK);
            this.buildMessage(param, responseData);
            this.logVendor(genericUrl.build(), statusCode, responseData.getMessage());
            return responseData;
        }
        catch (HttpResponseException httpException) {
            log.debug("HttpResponseException");
            log.debug("StatusCode: ", (Object)httpException.getStatusCode());
            log.debug("Content: ", (Object)httpException.getContent());
            if (httpException.getStatusCode() == 400 || httpException.getStatusCode() == 420 || httpException.getStatusCode() == 429) {
                EntityException entityException = (EntityException)gson.fromJson(httpException.getContent(), EntityException.class);
                ResponseException re = new ResponseException(entityException.getMessage(), entityException);
                this.logVendor(genericUrl.build(), httpException.getStatusCode(), entityException.getMessage());
                throw re;
            }
            this.logVendor(genericUrl.build(), httpException.getStatusCode(), httpException.getContent());
            throw httpException;
        }
    }

    private String buildStatus(EntityListResponse entityListResponse) {
        Entity[] subjects;
        StringBuilder sb = new StringBuilder();
        for (Entity entity : subjects = entityListResponse.getResult().getSubjects()) {
            sb.append(entity.getName()).append(", NIP: ").append(entity.getNip()).append(". ");
        }
        return sb.toString();
    }

    private void logVendor(String url, int httpCode, String message) {
        String info = "URL:\t" + url;
        this.vendorLogService.save(DateTime.now(), message, VendorSource.ONLINE, info, httpCode);
    }
}

