/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.vendor.checker.aplications;

import com.suncode.plugin.vendor.checker.actions.categories.Categories;
import com.suncode.plugin.vendor.checker.enums.EntityParams;
import com.suncode.plugin.vendor.checker.enums.SystemParametersKey;
import com.suncode.plugin.vendor.checker.exception.ConnectionException;
import com.suncode.plugin.vendor.checker.schemas.ParamData;
import com.suncode.plugin.vendor.checker.schemas.ResponseEntities;
import com.suncode.plugin.vendor.checker.services.EntitiesInfoService;
import com.suncode.plugin.vendor.checker.utils.Builder;
import com.suncode.plugin.vendor.checker.utils.DateStringConverter;
import com.suncode.plugin.vendor.checker.utils.EntityTransformer;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.PairedParam;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.AcceptanceContext;
import com.suncode.pwfl.workflow.WorkflowContext;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import com.suncode.pwfl.workflow.process.CommentService;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.Map;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@VariableSetter
@ComponentsFormScript(value="scripts/dpwe/entity-info-form.js")
public class EntityInfoApp {
    private static final Logger log = LoggerFactory.getLogger(EntityInfoApp.class);
    @Autowired
    private EntitiesInfoService entityInfoService;
    @Autowired
    private CommentService commentService;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("vendor.checker.entity-info.app")).name("vendor.checker.entity-info.name")).description("vendor.checker.entity-info.desc")).category(new Category[]{Categories.VENDOR})).icon((Icon)SilkIconPack.INFORMATION)).parameter().id("nipOrNrb").name("vendor.checker.param.nipOrNrb.name").description("vendor.checker.param.nipOrNrb.desc").type((Type)Types.STRING).create()).parameter().id("date").name("vendor.checker.param.date.name").description("vendor.checker.param.date.desc").type((Type)Types.DATE).optional().create()).parameter().id("searchType").name("vendor.checker.param.searchType.name").description("vendor.checker.param.searchType.desc").defaultValue((Object)"NIP").type((Type)Types.STRING).create()).parameter().id("entityParamsName").name("vendor.checker.param.entityParamsName.name").description("vendor.checker.param.entityParamsName.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("variables").name("vendor.checker.param.variables.name").description("vendor.checker.param.variables.desc").type((Type)Types.VARIABLE_ARRAY).create()).parameter().id("processingStatus").name("vendor.checker.param.processingStatus.name").description("vendor.checker.param.processingStatus.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("comment").name("vendor.checker.param.comment.name").description("vendor.checker.param.comment.desc").defaultValue((Object)Boolean.TRUE).type((Type)Types.BOOLEAN).create();
    }

    public void execute(@Param String nipOrNrb, @Param LocalDate date, @Param String searchType, @PairedParam(key="entityParamsName", value="variables") Map<String, Variable> mapping, @Param(value="processingStatus") Variable statusVar, @Param(value="comment") Boolean isOnComment, ApplicationContext context, Translator translator) {
        this.run(nipOrNrb, date, searchType, mapping, statusVar, isOnComment, (WorkflowContext)context, translator);
    }

    public void set(@Param String nipOrNrb, @Param LocalDate date, @Param String searchType, @PairedParam(key="entityParamsName", value="variables") Map<String, Variable> mapping, @Param(value="processingStatus") Variable statusVar, @Param(value="comment") Boolean isOnComment, AcceptanceContext context, Translator translator) {
        this.run(nipOrNrb, date, searchType, mapping, statusVar, isOnComment, (WorkflowContext)context, translator);
    }

    private void run(String nipOrNrb, LocalDate date, String searchType, Map<String, Variable> mapping, Variable statusVar, Boolean isOnComment, WorkflowContext context, Translator translator) {
        block7: {
            ParamData param = Builder.buildParamData(nipOrNrb, date, searchType);
            try {
                ResponseEntities responseEntity = this.entityInfoService.getEntities(param);
                String status = responseEntity.getSuccess() != false ? "OK" : responseEntity.getMessage();
                log.debug("Status: " + status);
                if (responseEntity.getSuccess().booleanValue()) {
                    this.mappingResultEntity(mapping, responseEntity);
                } else {
                    if (isOnComment.booleanValue()) {
                        this.setComment(status, context, "admin");
                    }
                    this.clearVariables(mapping);
                }
                if (statusVar != null) {
                    statusVar.setValue((Object)status);
                }
            }
            catch (ConnectionException ce) {
                log.error("Brak po\u0142\u0105czenia z Internetem \u2013 kontrahent nie zosta\u0142 zweryfikowany w bazie MF", (Throwable)ce);
                String status = translator.getMessage("error.connection", new Object[]{SystemProperties.getString((String)SystemParametersKey.SERWER_HOST.getName())});
                if (isOnComment.booleanValue()) {
                    this.setComment(status, context, "admin");
                }
                this.clearVariables(mapping);
                if (statusVar == null) break block7;
                statusVar.setValue((Object)status);
            }
        }
    }

    private void clearVariables(Map<String, Variable> mapping) {
        for (Variable variable : mapping.values()) {
            variable.setValue(null);
        }
    }

    private void mappingResultEntity(Map<String, Variable> mapping, ResponseEntities responseEntity) {
        log.debug("Mapping:");
        for (Map.Entry<String, Variable> mappingEntry : mapping.entrySet()) {
            EntityParams entityParam = EntityParams.valueOf(mappingEntry.getKey());
            Object obj = null;
            if (entityParam == EntityParams.REQUEST_ID) {
                obj = responseEntity.getRequestId();
            } else if (entityParam == EntityParams.REQUEST_DATETIME) {
                obj = DateStringConverter.requestStringToDateTime(responseEntity.getRequestDateTime());
            } else if (responseEntity.getTotalEntities() > 0) {
                obj = EntityTransformer.readParam(responseEntity.getEntities().get(0), entityParam, false);
            }
            log.debug(entityParam.name() + "\t:\t" + obj);
            mappingEntry.getValue().setValue(obj);
        }
    }

    private void setComment(String msg, WorkflowContext context, String userName) {
        Long commentId = this.commentService.createComment(Builder.buildComment(msg, context, userName));
        log.debug("Created comment, id: " + commentId);
    }
}

