/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.vendor.checker.aplications;

import com.suncode.plugin.vendor.checker.actions.categories.Categories;
import com.suncode.plugin.vendor.checker.enums.EntityHeaderParams;
import com.suncode.plugin.vendor.checker.enums.EntityParams;
import com.suncode.plugin.vendor.checker.enums.SystemParametersKey;
import com.suncode.plugin.vendor.checker.exception.ConnectionException;
import com.suncode.plugin.vendor.checker.schemas.EntityItem;
import com.suncode.plugin.vendor.checker.schemas.ParamData;
import com.suncode.plugin.vendor.checker.schemas.ResponseEntityDto;
import com.suncode.plugin.vendor.checker.services.EntitiesInfoService;
import com.suncode.plugin.vendor.checker.utils.Builder;
import com.suncode.plugin.vendor.checker.utils.EntityTransformer;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.PairedParam;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.AcceptanceContext;
import com.suncode.pwfl.workflow.WorkflowContext;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import com.suncode.pwfl.workflow.process.CommentService;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@VariableSetter
@ComponentsFormScript(value="scripts/dpwe/entities-info-form.js")
public class EntitiesInfoApp {
    private static final Logger log = LoggerFactory.getLogger(EntitiesInfoApp.class);
    @Autowired
    private EntitiesInfoService entityInfoService;
    @Autowired
    private CommentService commentService;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("vendor.checker.entities-info.app")).name("vendor.checker.entities-info.name")).description("vendor.checker.entities-info.desc")).category(new Category[]{Categories.VENDOR})).icon((Icon)SilkIconPack.INFORMATION)).parameter().id("nipsOrNrbs").name("vendor.checker.param.nipsOrNrbs.name").description("vendor.checker.param.nipsOrNrbs.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("dates").name("vendor.checker.param.dates.name").description("vendor.checker.param.dates.desc").type((Type)Types.DATE_ARRAY).optional().create()).parameter().id("searchType").name("vendor.checker.param.searchType.name").description("vendor.checker.param.searchType.desc").defaultValue((Object)"NIPS").type((Type)Types.STRING).create()).parameter().id("entityParamsName").name("vendor.checker.param.entityParamsName.name").description("vendor.checker.param.entityParamsName.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("variables").name("vendor.checker.param.variables.name").description("vendor.checker.param.variables.desc").type((Type)Types.VARIABLE_ARRAY).create()).parameter().id("processingStatus").name("vendor.checker.param.processingStatus.name").description("vendor.checker.param.processingStatus.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("comment").name("vendor.checker.param.comment.name").description("vendor.checker.param.comment.desc").defaultValue((Object)Boolean.TRUE).type((Type)Types.BOOLEAN).create();
    }

    public void execute(@Param String[] nipsOrNrbs, @Param LocalDate[] dates, @Param String searchType, @PairedParam(key="entityParamsName", value="variables") Map<String, Variable> mapping, @Param(value="processingStatus") Variable statusVar, @Param(value="comment") Boolean isOnComment, ApplicationContext context, Translator translator) {
        this.run(nipsOrNrbs, dates, searchType, mapping, statusVar, isOnComment, (WorkflowContext)context, translator);
    }

    public void set(@Param String[] nipsOrNrbs, @Param LocalDate[] dates, @Param String searchType, @PairedParam(key="entityParamsName", value="variables") Map<String, Variable> mapping, @Param(value="processingStatus") Variable statusVar, @Param(value="comment") Boolean isOnComment, AcceptanceContext context, Translator translator) {
        this.run(nipsOrNrbs, dates, searchType, mapping, statusVar, isOnComment, (WorkflowContext)context, translator);
    }

    private void run(String[] nipsOrNrbs, LocalDate[] dates, String searchType, Map<String, Variable> mapping, Variable statusVar, Boolean isOnComment, WorkflowContext context, Translator translator) {
        block5: {
            List<ParamData> paramsData = Builder.buildMultiParamData(nipsOrNrbs, dates, searchType);
            try {
                ResponseEntityDto responseEntityDto = this.entityInfoService.getResponseEntityDto(paramsData);
                this.clearVariables(mapping);
                this.mappingResultEntity(mapping, responseEntityDto.getEntityItemMap(), nipsOrNrbs, dates);
                if (isOnComment.booleanValue() && !responseEntityDto.getSuccess().booleanValue()) {
                    this.setComment(responseEntityDto.getStatus(), context, "admin");
                }
                if (statusVar != null) {
                    statusVar.setValue((Object)responseEntityDto.getStatus());
                }
            }
            catch (ConnectionException ce) {
                log.error("Brak po\u0142\u0105czenia z Internetem \u2013 kontrahent nie zosta\u0142 zweryfikowany w bazie MF", (Throwable)ce);
                String status = translator.getMessage("error.connection", new Object[]{SystemProperties.getString((String)SystemParametersKey.SERWER_HOST.getName())});
                if (isOnComment.booleanValue()) {
                    this.setComment(status, context, "admin");
                }
                this.clearVariables(mapping);
                if (statusVar == null) break block5;
                statusVar.setValue((Object)status);
            }
        }
    }

    private void clearVariables(Map<String, Variable> mapping) {
        for (Variable variable : mapping.values()) {
            variable.setValue(null);
        }
    }

    private void mappingResultEntity(Map<String, Variable> mapping, Map<String, EntityItem> entityItemMap, String[] nipsOrNrbs, LocalDate[] dates) {
        log.debug("Mapping:");
        for (Map.Entry<String, Variable> mappingEntry : mapping.entrySet()) {
            EntityHeaderParams entityParam = EntityHeaderParams.valueOf(mappingEntry.getKey());
            ArrayList<String> values = new ArrayList<String>();
            for (int index = 0; index < nipsOrNrbs.length; ++index) {
                String orgNipOrNrb = nipsOrNrbs[index];
                String value = "";
                if (orgNipOrNrb != null) {
                    String nipOrNrb = orgNipOrNrb.replaceAll("\\D", "");
                    String date = Builder.readDate(index, dates).toString();
                    String key = nipOrNrb + "##" + date;
                    if (StringUtils.isNotBlank((CharSequence)nipOrNrb) && entityItemMap.containsKey(key)) {
                        EntityItem entityItem = entityItemMap.get(key);
                        if (entityParam == EntityHeaderParams.REQUEST_ID) {
                            value = entityItem.getRequestId();
                        } else if (entityParam == EntityHeaderParams.REQUEST_DATETIME) {
                            value = entityItem.getRequestDateTime();
                        } else if (entityParam == EntityHeaderParams.ERROR_MESSEGE) {
                            value = entityItem.getErrorMessege();
                        } else if (entityItem.getSubject() != null) {
                            Object obj = EntityTransformer.readParam(entityItem.getSubject(), EntityParams.valueOf(mappingEntry.getKey()), true);
                            value = obj == null ? "" : obj.toString();
                        }
                    }
                }
                values.add(value);
            }
            log.debug(entityParam.name() + "\t:\t" + values);
            Variable variable = mappingEntry.getValue();
            variable.setValue(variable.getType().convert(String.join((CharSequence)";", values)));
        }
    }

    private void setComment(String msg, WorkflowContext context, String userName) {
        Long commentId = this.commentService.createComment(Builder.buildComment(msg, context, userName));
        log.debug("Created comment, id: " + commentId);
    }
}

