/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.vendor.checker.aplications;

import com.suncode.plugin.vendor.checker.actions.categories.Categories;
import com.suncode.plugin.vendor.checker.enums.SystemParametersKey;
import com.suncode.plugin.vendor.checker.schemas.CheckDto;
import com.suncode.plugin.vendor.checker.schemas.ParamData;
import com.suncode.plugin.vendor.checker.services.CheckService;
import com.suncode.plugin.vendor.checker.utils.Builder;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.user.UserInfo;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.AcceptanceContext;
import com.suncode.pwfl.workflow.WorkflowContext;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import com.suncode.pwfl.workflow.process.CommentService;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@VariableSetter
@ComponentsFormScript(value="scripts/dpwe/check-iban-app-form.js")
public class CheckIBAN {
    private static final Logger log = LoggerFactory.getLogger(CheckIBAN.class);
    @Autowired
    private CheckService checkService;
    @Autowired
    private CommentService commentService;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("vendor.checker.check-iban.app")).name("application.vendor.checker.check-iban.name")).description("application.vendor.checker.check-iban.desc")).category(new Category[]{Categories.VENDOR})).icon((Icon)SilkIconPack.XHTML_VALID)).parameter().id("nip_regon").name("vendor.checker.param.nip.name").description("vendor.checker.param.nip.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("iban").name("vendor.checker.param.iban.name").description("vendor.checker.param.iban.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("date").name("vendor.checker.param.date.name").description("vendor.checker.param.date.desc").type((Type)Types.DATE_ARRAY).optional().create()).parameter().id("status").name("vendor.checker.param.status.name").description("vendor.checker.param.status.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("comment").name("vendor.checker.param.comment.name").description("vendor.checker.param.comment.desc").type((Type)Types.BOOLEAN).defaultValue((Object)false).create()).parameter().id("addRequestId").name("vendor.checker.param.addRequestId.name").description("vendor.checker.param.addRequestId.desc").type((Type)Types.BOOLEAN).defaultValue((Object)false).create()).parameter().id("requestId").name("vendor.checker.param.requestId.name").description("vendor.checker.param.requestId.desc").type((Type)Types.VARIABLE).optional().create();
    }

    public void execute(@Param(value="nip_regon") String[] nips, @Param(value="iban") String[] ibans, @Param(value="date") LocalDate[] date, @Param(value="status") Variable statusVar, @Param(value="comment") Boolean isOnComment, @Param(value="addRequestId") Boolean addRequestId, @Param(value="requestId") Variable requestId, ApplicationContext context, Translator translator, UserInfo userInfo) {
        this.valid(nips, ibans, date, statusVar, isOnComment, addRequestId, requestId, (WorkflowContext)context, translator, userInfo);
    }

    public void set(@Param(value="nip_regon") String[] nips, @Param(value="iban") String[] ibans, @Param(value="date") LocalDate[] date, @Param(value="status") Variable statusVar, @Param(value="comment") Boolean isOnComment, @Param(value="addRequestId") Boolean addRequestId, @Param(value="requestId") Variable requestId, AcceptanceContext context, Translator translator, UserInfo userInfo) {
        this.valid(nips, ibans, date, statusVar, isOnComment, addRequestId, requestId, (WorkflowContext)context, translator, userInfo);
    }

    private void valid(String[] nips, String[] ibans, LocalDate[] dates, Variable statusVar, Boolean isOnComment, Boolean addRequestId, Variable requestId, WorkflowContext context, Translator translator, UserInfo userInfo) {
        LocalDate[] localDateArray;
        if (dates == null) {
            LocalDate[] localDateArray2 = new LocalDate[1];
            localDateArray = localDateArray2;
            localDateArray2[0] = DateTime.now().toLocalDate();
        } else {
            localDateArray = dates;
        }
        LocalDate[] dateParam = localDateArray;
        List<ParamData> paramsInput = Builder.buildParamDatas(nips, ibans, dateParam);
        StringBuilder statusMsg = new StringBuilder();
        StringBuilder requestIdMsg = new StringBuilder();
        StringBuilder commentMsg = new StringBuilder();
        Boolean firstLoop = true;
        for (ParamData paramData : paramsInput) {
            try {
                CheckDto checkDto = Builder.buildCheckDto(paramData, this.checkService.check(paramData, context.getProcessId()));
                if (!firstLoop.booleanValue()) {
                    statusMsg.append(";");
                    commentMsg.append("<br>");
                    requestIdMsg.append(";");
                } else {
                    firstLoop = false;
                }
                statusMsg.append(checkDto.getMessage());
                if (isOnComment.booleanValue()) {
                    String msg = checkDto.getMessage();
                    if (checkDto.getSuccess().booleanValue()) {
                        msg = translator.getMessage(checkDto.getCommentKey(), new Object[]{checkDto.getCommentValue(), paramData.getNrb()});
                        if (addRequestId.booleanValue()) {
                            msg = msg + " " + translator.getMessage("comment.requestID", new Object[]{checkDto.getReuestId()});
                        }
                    }
                    commentMsg.append(msg);
                }
                if (requestId == null) continue;
                requestIdMsg.append(checkDto.getReuestId());
            }
            catch (ExecutionException e) {
                if (!firstLoop.booleanValue()) {
                    statusMsg.append(";");
                    commentMsg.append("<br>");
                    requestIdMsg.append(";");
                } else {
                    firstLoop = false;
                }
                requestIdMsg.append("");
                commentMsg.append(translator.getMessage("error.connection", new Object[]{SystemProperties.getString((String)SystemParametersKey.SERWER_HOST.getName())}));
                statusMsg.append(translator.getMessage("error.connection", new Object[]{SystemProperties.getString((String)SystemParametersKey.SERWER_HOST.getName())}));
            }
        }
        this.setVariableValue(statusVar, statusMsg.toString());
        this.setVariableValue(requestId, requestIdMsg.toString());
        if (isOnComment.booleanValue()) {
            this.setComment(commentMsg.toString(), context, userInfo != null ? userInfo.getUserName() : null);
        }
    }

    private void setVariableValue(Variable variable, String message) {
        if (variable != null) {
            if (variable.isArray()) {
                variable.setValue((Object)message.split(";"));
            } else {
                variable.setValue((Object)message);
            }
        }
    }

    private void setComment(String msg, WorkflowContext context, String userName) {
        Long commentId = this.commentService.createComment(Builder.buildComment(msg, context, userName));
        log.debug("Created comment, id: " + commentId);
    }
}

