var variableService = ServiceFactory.getVariableService();
var messageService = ServiceFactory.getMessageService();
var variableSetService = ServiceFactory.getVariableSetService();

PW.FormActions
		.create(
				'save-table-as-template',
				{

					variableSetInit : function(variableSet) {

						var buttonName = this.get("button-name");

						var settingObj = [];
						settingObj["buttonName"] = buttonName;
						settingObj["category-name"] = this.get("category-name");
						settingObj["icon-name"] = this.get("icon-name");
						settingObj["set-default"] = this.get("set-default");
						settingObj["hide-check-box"] = this
								.get("hide-check-box");
                        settingObj["set-overwrite-template"] = this.get("set-overwrite-template");
                        settingObj["hide-check-box-overwrite-template"] = this.get("hide-check-box-overwrite-template");

						if (this.get("select-columns-id").length > 0) {

							settingObj["select-columns-id"] = [];
							for (var i = 0; i < this.get("select-columns-id").length; i++) {

								settingObj["select-columns-id"].push(this
										.get("select-columns-id")[i].getId());
							}

						}

						settingObj["varaibleSet"] = variableSetService
								.get(variableSet.getId());

						var func = this.saveTamplate;
						variableSetService
								.addBottomToolbarButton(
										settingObj["varaibleSet"], {

											iconCls : "silk-"
													+ settingObj["icon-name"],
											text : buttonName,
											handler : function() {

												func(settingObj);
											}
										});
					},

					saveTamplate : function(obj) {

						CUF.FormTemplateService.openTemplateCreator({
							setDefault : obj["set-default"],
							category : obj["category-name"],
							fields : [ {
								type : "variableset",
								id : obj["varaibleSet"].getId()
							} ],
							allowFieldsSelection : false,
							filter : "variableset",
							hideCheckboxDefault : obj["hide-check-box"],
                            hideCheckboxOverwriteTemplate:obj["hide-check-box-overwrite-template"],
                            setOverwriteTemplate:obj["set-overwrite-template"],
							columnsId : obj["select-columns-id"]
						});
					},
					defaultActions : {
						button : function(button) {
						},

						variableSet : function(variableSet, added, updated,
								removed) {
						}
					}

				});