var variableService = ServiceFactory.getVariableService();
var messageService = ServiceFactory.getMessageService();
var variableSetService = ServiceFactory.getVariableSetService();

PW.FormActions.create('insert-json-to-table', {

	init : function() {

		this.variableSetID = this.get("id-variable-set");

		this.variableSetComponent = variableSetService.get(this.variableSetID);

	},

	defaultActions : {

		variable : function(variable, newValue, oldValue) {

			if (!(newValue == "")) {
				this.isAutoClear = this.get("auto-clear-set");

				var index = variableSetService
						.getRowsCount(this.variableSetComponent);
				if (this.isAutoClear) {
					variableSetService.clear(this.variableSetComponent);
				}

				try {
					jsonObject = JSON.parse(newValue);

					variableSetService.insertRow(this.variableSetComponent,
							index, false, jsonObject);

					variable.setValue("");
				} catch (err) {
					console.log("Wrong JSON format");
				}
			}
		}
	}

});