PW.FormActions.create('button-column-fill-const-txt', {
    variableSetInit: function (variableSet) {
        let buttonName = this.get("button-name");
        let iconName = this.get("icon-name");
        let table = VariableSetService.get(variableSet.getId());
        let settings = {};
        settings['this'] = this;
        settings["column-set"] = this.get("column-set");
        settings["default-value-set"] = this.get("default-value-set");

        VariableSetService.addBottomToolbarButton(table, {
            iconCls: "silk-" + iconName,
            text: buttonName,
            handler: () => {
                this.buttonFunc(variableSet, settings);
            }
        });
    },
    enable: function () {
        this.isEnable = true;
    },
    disable: function () {
        this.isEnable = false;
    },
    buttonFunc: function (table, settings) {
        if (this.isEnable) {
            let column = [];
            for (let int = 0; int < table.grid.getStore().getCount(); int++) {
                column[int] = settings['this'].get("default-value-set");
            }

            let variableSet = VariableSetService.get(table.getId());
            VariableSetService.setValue(variableSet, null, settings["column-set"].getId(), column);
        }
    }
});