/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.servlet;

import com.suncode.cuf.currency.ExchangeService;
import com.suncode.cuf.currency.RateDto;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/exchangerate"})
public class PLNExchangeRateController {
    @Autowired
    ExchangeService exchangeService;

    @RequestMapping(value={"/pln"}, method={RequestMethod.GET})
    @ResponseBody
    public RateDto getExchangeRate(@RequestParam String currency, @RequestParam Date date) throws Exception {
        if (date == null || currency == null) {
            throw new IllegalArgumentException("Nieprawid\u0142owy parametr data lub waluta");
        }
        if ("PLN".equals(currency)) {
            RateDto rate = new RateDto();
            rate.setMid(Double.valueOf(1.0));
            return rate;
        }
        LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        RateDto rate = this.exchangeService.getLastNbpExchangeWithTableSymbol(currency, localDate);
        if (rate == null) {
            throw new IllegalArgumentException("Nie znaleziono kursu dla podanej waluty: " + currency + " i daty" + localDate.toString());
        }
        return rate;
    }
}

