/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.servlet;

import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.search.CountedResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/dpwe"})
public class DPWEController {
    private static final Logger log = LoggerFactory.getLogger(DPWEController.class);
    @Autowired
    private DocumentClassService docClassService;

    @RequestMapping(value={"docClassIndexList"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<Map<String, String>> getDocumentClassIndexListEmpty(@RequestParam String query, @RequestParam String start, @RequestParam String limit) {
        CountedResult result = new CountedResult();
        ArrayList dataError = new ArrayList();
        HashMap<String, String> errorResult = new HashMap<String, String>();
        errorResult.put("docClassIndexId", "");
        errorResult.put("docClassIndexName", "");
        errorResult.put("docClassIndexDesc", "No selected Documents Class");
        errorResult.put("docClassIndexType", "Empty");
        dataError.add(errorResult);
        result.setData(dataError);
        result.setTotal(1L);
        return result;
    }

    @RequestMapping(value={"docClassIndexList/{className}"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<Map<String, String>> getDocumentClassIndexList(@PathVariable(value="className") String className, @RequestParam String query, @RequestParam String start, @RequestParam String limit) {
        CountedResult result = new CountedResult();
        try {
            DocumentClass docClass = this.docClassService.getDocumentClass(className, new String[]{"indexes"});
            Assert.notNull((Object)docClass, (String)("Document class " + className + " not found"));
            ArrayList docClassIndexInfoList = new ArrayList();
            for (DocumentClassIndex docClassIndexes : docClass.getIndexes()) {
                HashMap<String, String> docClassindexInfo = new HashMap<String, String>();
                docClassindexInfo.put("docClassIndexId", docClassIndexes.getId().toString());
                docClassindexInfo.put("docClassIndexName", docClassIndexes.getName());
                docClassindexInfo.put("docClassIndexDesc", docClassIndexes.getDescription());
                docClassindexInfo.put("docClassIndexType", docClassIndexes.getType().toString());
                docClassIndexInfoList.add(docClassindexInfo);
            }
            int totalResult = docClassIndexInfoList.size();
            if (!StringUtils.isBlank((CharSequence)query)) {
                docClassIndexInfoList.stream().filter(map -> ((String)map.get("docClassIndexName")).toLowerCase().contains(query.toLowerCase()) || ((String)map.get("docClassIndexId")).toLowerCase().contains(query.toLowerCase())).collect(Collectors.toList());
            }
            Long startL = Long.valueOf(start);
            Long limitL = Long.valueOf(limit);
            if (docClassIndexInfoList.size() > limitL.intValue()) {
                result.setData(docClassIndexInfoList.subList(startL.intValue(), startL.intValue() + limitL.intValue()));
            } else {
                result.setData(docClassIndexInfoList.subList(startL.intValue(), docClassIndexInfoList.size()));
            }
            result.setTotal((long)totalResult);
        }
        catch (Exception e) {
            log.debug("", (Throwable)e);
            ArrayList dataError = new ArrayList();
            HashMap<String, String> errorResult = new HashMap<String, String>();
            errorResult.put("docClassIndexId", "");
            errorResult.put("docClassIndexName", "");
            errorResult.put("docClassIndexDesc", e.getMessage());
            errorResult.put("docClassIndexType", "Server error");
            dataError.add(errorResult);
            result.setData(dataError);
        }
        return result;
    }
}

