/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.scheduledtask.util;

import org.apache.log4j.Logger;

public class CompressionDecompressionTaskStatistics {
    private Long errorFiles = 0L;
    private int toProcessedFiles = 0;
    private Long successProcessedFile = 0L;
    private Long datasourceErrors = 0L;
    private Logger logger;
    private boolean timeout = false;

    public CompressionDecompressionTaskStatistics(Logger logger) {
        this.logger = logger;
    }

    public synchronized void setTimeout() {
        this.timeout = true;
    }

    public synchronized void logDebug(String log) {
        this.logger.debug((Object)(Thread.currentThread().getName() + ": " + log));
    }

    public synchronized void logError(String log, Throwable e) {
        this.logger.error((Object)(Thread.currentThread().getName() + ": " + log), e);
    }

    public synchronized void incErrorFiles() {
        Long l = this.errorFiles;
        this.errorFiles = this.errorFiles + 1L;
    }

    public synchronized void incErrorDatasource() {
        Long l = this.datasourceErrors;
        this.datasourceErrors = this.datasourceErrors + 1L;
    }

    public synchronized void incSuccessProcessedFile() {
        Long l = this.successProcessedFile;
        this.successProcessedFile = this.successProcessedFile + 1L;
    }

    public synchronized long getNotProcessedCount() {
        return (long)this.toProcessedFiles - this.errorFiles - this.successProcessedFile;
    }

    public String summary() {
        StringBuilder sb = new StringBuilder();
        sb.append("Success ").append(this.successProcessedFile).append("/").append(this.toProcessedFiles).append(" ");
        sb.append("Error ").append(this.errorFiles).append("/").append(this.toProcessedFiles).append(" ");
        sb.append("Not processed ").append(this.getNotProcessedCount()).append("/").append(this.toProcessedFiles).append(" ");
        sb.append("Datasource execution error: ").append(this.datasourceErrors);
        return sb.toString();
    }

    public Long getErrorFiles() {
        return this.errorFiles;
    }

    public void setToProcessedFiles(int toProcessedFiles) {
        this.toProcessedFiles = toProcessedFiles;
    }

    public int getToProcessedFiles() {
        return this.toProcessedFiles;
    }

    public Long getSuccessProcessedFile() {
        return this.successProcessedFile;
    }

    public Long getDatasourceErrors() {
        return this.datasourceErrors;
    }

    public boolean isTimeout() {
        return this.timeout;
    }
}

