/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.savefile.service.impl;

import com.suncode.plugin.tools.savefile.dto.FileToSaveDto;
import com.suncode.plugin.tools.savefile.hook.DestinationFileHook;
import com.suncode.plugin.tools.savefile.service.ReadingFileService;
import com.suncode.plugin.tools.savefile.service.SavingFileService;
import com.suncode.plugin.tools.savefile.support.RenamingFileNames;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.core.function.FunctionCall;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SavingFileServiceImpl
implements SavingFileService {
    @Autowired
    private ReadingFileService readingFileService;
    @Autowired
    private FileService fileService;

    @Override
    public void saveFilesFromProcess(String processId, DestinationFileHook hook, String directory, FunctionCall fileName, String[] documentClassNames, String regex) {
        List<WfFile> files = this.readingFileService.readFilesFromProcess(processId, documentClassNames, regex);
        this.writeFiles(hook, fileName, directory, files);
    }

    @Override
    public void saveFilesFromArchive(DestinationFileHook hook, String documentClassName, Map<String, String> indexesMapping, String directory, FunctionCall fileName, String regex) {
        List<WfFile> files = this.readingFileService.readFilesFromArchive(documentClassName, indexesMapping, regex);
        this.writeFiles(hook, fileName, directory, files);
    }

    @Override
    public void saveSelectedFilesByIds(DestinationFileHook hook, Integer[] fileIdList, String directory, FunctionCall fileName) {
        List<WfFile> files = this.readingFileService.readSelectedFilesByIds(fileIdList);
        this.writeFiles(hook, fileName, directory, files);
    }

    private void writeFiles(DestinationFileHook context, FunctionCall fileName, String directory, List<WfFile> files) {
        RenamingFileNames renamingFiles = new RenamingFileNames();
        List<FileToSaveDto> destinationFilesNames = renamingFiles.getDestinationFileNames(context, fileName, files);
        for (FileToSaveDto fileToSave : destinationFilesNames) {
            this.saveFileToDisk(fileToSave, directory);
        }
    }

    private void saveFileToDisk(FileToSaveDto fileToSave, String directory) {
        boolean created;
        File dir = new File(directory);
        if (!dir.exists() && !(created = dir.mkdirs())) {
            throw new RuntimeException("Failed to create directory: " + directory);
        }
        File file = new File(dir, fileToSave.getName());
        try (FileOutputStream fos = new FileOutputStream(file);
             InputStream stream = this.fileService.getFileInputStream(fileToSave.getId());){
            fos.write(IOUtils.toByteArray((InputStream)stream));
        }
        catch (IOException e) {
            throw new RuntimeException("Error while saving file: " + file.getAbsolutePath(), e);
        }
    }
}

