/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.savefile.service.impl;

import com.plusmpm.database.dbspecific.NativeDatabase;
import com.plusmpm.database.dbspecific.NativeSql;
import com.suncode.plugin.tools.savefile.service.ReadingFileService;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.IndexType;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.archive.search.IndexFilter;
import com.suncode.pwfl.archive.search.SimpleIndexFilter;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ReadingFileServiceImpl
implements ReadingFileService {
    private static final Logger log = LoggerFactory.getLogger(ReadingFileServiceImpl.class);
    @Autowired
    private DocumentFinder documentFinder;
    @Autowired
    private DocumentClassService documentClassService;
    @Autowired
    private FileService fileService;

    @Override
    public List<WfFile> readFilesFromProcess(String processId, String[] documentClassNames, String regex) {
        Pattern pattern = Pattern.compile(regex);
        if (documentClassNames.length == 0) {
            List documents = this.documentFinder.getDocumentsFromProcess(processId, new String[0]);
            log.debug("Found " + documents.size() + " files attached to the process '" + processId + "'");
            return documents.stream().map(document -> document.getFile()).filter(document -> {
                Matcher matcher = pattern.matcher(document.getFileName());
                return matcher.matches();
            }).collect(Collectors.toList());
        }
        HashSet<String> distinctDocumentClasses = new HashSet<String>(Arrays.asList(documentClassNames));
        LinkedList<WfFile> allWfFiles = new LinkedList<WfFile>();
        distinctDocumentClasses.stream().forEach(documentClass -> {
            List documents = this.documentFinder.getDocumentsFromProcessAndClass(processId, documentClass, new String[]{"documentClass"});
            List wfFiles = documents.stream().map(document -> document.getFile()).filter(document -> {
                Matcher matcher = pattern.matcher(document.getFileName());
                return matcher.matches();
            }).collect(Collectors.toList());
            allWfFiles.addAll(wfFiles);
        });
        log.debug("Found " + allWfFiles.size() + " files attached to the process '" + processId + "'");
        return allWfFiles;
    }

    @Override
    public List<WfFile> readFilesFromArchive(String documentClassName, Map<String, String> indexesMapping, String regex) {
        Pattern pattern = Pattern.compile(regex);
        DocumentClass documentClass = this.documentClassService.getDocumentClass(documentClassName, new String[]{"indexes"});
        if (!this.indexesNamesExist(indexesMapping, documentClass)) {
            throw new IllegalArgumentException("An entered index/indexes do not exist in the document class '" + documentClass.getName() + "'");
        }
        List<IndexFilter> indexFilters = this.createIndexFilterList(documentClass, indexesMapping);
        List documents = this.documentFinder.findByIndexes(documentClass.getId(), indexFilters, null, Integer.valueOf(0), Integer.valueOf(0), new String[0]).getData();
        log.debug("Found " + documents.size() + " files in the archive in document Class: " + documentClassName);
        return documents.stream().map(document -> document.getFile()).filter(document -> {
            Matcher matcher = pattern.matcher(document.getFileName());
            return matcher.matches();
        }).collect(Collectors.toList());
    }

    @Override
    public List<WfFile> readSelectedFilesByIds(Integer[] fileIdList) {
        return Arrays.stream(fileIdList).map(fileId -> {
            WfFile file = this.fileService.getFile(Long.valueOf(fileId.intValue()), new String[0]);
            if (file == null) {
                throw new RuntimeException("A file with id '" + fileId + "' does not exist in the archive");
            }
            return file;
        }).collect(Collectors.toList());
    }

    private List<IndexFilter> createIndexFilterList(DocumentClass documentClass, Map<String, String> indexesMapping) {
        return documentClass.getIndexes().stream().filter(index -> indexesMapping.containsKey(index.getName()) && StringUtils.isNotBlank((CharSequence)((CharSequence)indexesMapping.get(index.getName())))).map(index -> this.buildIndexFilter((String)indexesMapping.get(index.getName()), (DocumentClassIndex)index)).collect(Collectors.toList());
    }

    private boolean indexesNamesExist(Map<String, String> indexesMapping, DocumentClass documentClass) {
        if (indexesMapping.isEmpty()) {
            return true;
        }
        Set documentClassIndexes = documentClass.getIndexes().stream().map(index -> index.getName()).collect(Collectors.toSet());
        return CollectionUtils.containsAny(indexesMapping.keySet(), documentClassIndexes);
    }

    private SimpleIndexFilter buildIndexFilter(String stringValue, DocumentClassIndex documentClassIndex) {
        Object value = this.indexConverter(stringValue, documentClassIndex.getType());
        return new SimpleIndexFilter(documentClassIndex.getId(), value);
    }

    private Object indexConverter(String stringValue, IndexType indexType) {
        switch (indexType) {
            case DATE: {
                return this.convertLocaldateToDate(new LocalDate((Object)stringValue));
            }
            case DATETIME: {
                LocalDateTime localDateTime = LocalDateTime.parse((String)stringValue, (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss"));
                return this.convertLocaldatetimeToTimestamp(localDateTime);
            }
            case DOUBLE: {
                stringValue = stringValue.replaceAll(",", ".");
                return indexType.parse(stringValue);
            }
            case BOOLEAN: {
                boolean booleanValue = StringUtils.isBlank((CharSequence)stringValue) ? false : stringValue.toLowerCase().equals("true") || stringValue.equals("1");
                NativeSql databaseImpl = NativeDatabase.getImplementation();
                return databaseImpl.getBooleanValue(booleanValue);
            }
        }
        return indexType.parse(stringValue);
    }

    private Date convertLocaldateToDate(LocalDate date) {
        return date == null ? null : new Date(date.toDateTimeAtStartOfDay(DateTimeZone.forID((String)"UTC")).getMillis());
    }

    private Timestamp convertLocaldatetimeToTimestamp(LocalDateTime dateTime) {
        return dateTime == null ? null : new Timestamp(dateTime.toDateTime().getMillis());
    }
}

