/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.money.service;

import com.suncode.plugin.tools.money.componets.ConvertNumberToText;
import com.suncode.plugin.tools.money.componets.Money;
import com.suncode.plugin.tools.money.service.VerbalDescriptionService;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VerbalDescriptionServiceImpl
implements VerbalDescriptionService {
    private static final Logger log = LoggerFactory.getLogger(VerbalDescriptionServiceImpl.class);
    private ConvertNumberToText convertNumberToText;
    private Money money;

    @Autowired
    public VerbalDescriptionServiceImpl(ConvertNumberToText convertNumberToText, Money money) {
        this.convertNumberToText = convertNumberToText;
        this.money = money;
    }

    @Override
    public String translateToPLNMoney(BigDecimal amount) {
        amount = amount.setScale(2, 4);
        String[] moneyArray = amount.toString().split("\\.");
        StringBuilder sb = new StringBuilder();
        if (moneyArray != null && moneyArray.length > 0) {
            Long value1 = Long.parseLong(moneyArray[0]);
            Long value2 = 0L;
            sb.append(this.convertNumberToText.convert(value1)).append(this.money.getZloty(value1));
            if (moneyArray.length == 2) {
                value2 = Long.parseLong(moneyArray[1].trim());
                if (moneyArray[1].length() == 1) {
                    value2 = value2 * 10L;
                }
            }
            sb.append(this.convertNumberToText.convert(value2)).append(this.money.getGrosz(value2));
        }
        String temp = sb.toString().trim();
        return temp.substring(0, 1).toUpperCase() + temp.substring(1);
    }
}

