/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.dynamictable.datachooser;

import com.google.gson.Gson;
import com.suncode.dbexplorer.DatabaseExplorer;
import com.suncode.plugin.tools.categories.Categories;
import com.suncode.plugin.tools.dbexplorer.DatabaseService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.component.ComponentQueryData;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserDefinitionBuilder;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserResult;
import com.suncode.pwfl.workflow.form.datachooser.annotation.DataChooser;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;

@DataChooser
public class JSONDataChooser {
    public static Logger log = Logger.getLogger(JSONDataChooser.class);
    @Autowired
    DatabaseExplorer dbExplorer;

    @Define
    public void definition(DataChooserDefinitionBuilder builder) {
        ((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)builder.id("json-datachooser")).name("datachooser.json-datachooser.name")).description("datachooser.json-datachooser.desc")).category(new Category[]{Categories.TOOLS_FOR_DYNAMIC_TABLE})).icon((Icon)SilkIconPack.TAB_ADD)).icon((Icon)SilkIconPack.TEXT_LIST_BULLETS)).parameter().id("db-alias").name("datachooser.json-datachooser.param.db-alias.name").description("datachooser.json-datachooser.param.db-alias.desc").type((Type)Types.STRING).create()).parameter().id("querydatachooser-name").name("datachooser.json-datachooser.param.querydatachooser-name.name").description("datachooser.json-datachooser.param.querydatachooser-name.desc").type((Type)Types.STRING).create()).parameter().id("parameters-query").name("datachooser.json-datachooser.param.parameters-query.name").description("datachooser.json-datachooser.param.parameters-query.desc").optional().type((Type)Types.VARIABLE_ARRAY).create()).parameter().id("table_variable").name("datachooser.json-datachooser.param.table_variable.name").description("datachooser.json-datachooser.param.table_variable.desc").type((Type)Types.VARIABLE_ARRAY).create()).parameter().id("column-name-to-jason").name("datachooser.json-datachooser.param.column-name-to-jason.name").description("datachooser.json-datachooser.param.column-name-to-jason.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("column-name-to-group-data").name("datachooser.json-datachooser.param.column-name-to-group-data.name").description("datachooser.json-datachooser.param.column-name-to-group-data.desc").type((Type)Types.STRING_ARRAY).create()).mapping().id("json-map").name("datachooser.json-datachooser.map.json-map.name").description("datachooser.json-datachooser.map.json-map.desc").create().enableCustomMappings();
    }

    public void data(DataChooserResult result, Parameters param, ComponentQueryData componentQueryData) {
        log.debug((Object)"read data");
        Integer start = componentQueryData.getPagination().getStart();
        Integer limit = componentQueryData.getPagination().getLimit();
        String aliasDB = (String)param.get("db-alias", String.class);
        String queryName = (String)param.get("querydatachooser-name", String.class);
        String[] columnNameToJSON = (String[])param.get("column-name-to-jason", String[].class);
        String[] columnNameToGroupData = (String[])param.get("column-name-to-group-data", String[].class);
        Variable[] paramQuery = (Variable[])param.get("parameters-query", Variable[].class);
        Variable[] tableVar = (Variable[])param.get("table_variable", Variable[].class);
        log.debug((Object)("aliasDB: " + aliasDB));
        log.debug((Object)("queryName: " + queryName));
        log.debug((Object)("columnNameToJSON: " + String.valueOf(columnNameToJSON)));
        log.debug((Object)("columnNameToGroupData: " + String.valueOf(columnNameToGroupData)));
        log.debug((Object)("paramQuery: " + String.valueOf(paramQuery)));
        log.debug((Object)("paramQuery: " + String.valueOf(tableVar)));
        String[] tableID = this.getIDFromVaraibales(tableVar);
        log.debug((Object)"convert parameter to map");
        Map<String, String> mapParamQuery = this.convertParamQuery(paramQuery);
        log.debug((Object)" ad DCKEY");
        mapParamQuery.put("DCKEY", "'" + componentQueryData.getQuery() + "'");
        Map filtres = componentQueryData.getFilters();
        for (String key : filtres.keySet()) {
            mapParamQuery.put("DCKEY_" + key, "'" + (String)filtres.get(key) + "'");
        }
        log.debug((Object)"Create service to System Data Base where is pm_querydatachooser");
        DatabaseService dbServiceSystem = new DatabaseService(this.dbExplorer);
        log.debug((Object)"Create service to external Data Base");
        DatabaseService dbServiceExternalDB = new DatabaseService(this.dbExplorer, aliasDB);
        log.debug((Object)"Get query from pm_querydatachooser and build complete query");
        String[] rawQuery = dbServiceSystem.getQueryAndParameters(queryName);
        log.debug((Object)rawQuery[0]);
        log.debug((Object)rawQuery[1]);
        String query = this.processQuery(rawQuery[0], rawQuery[1], mapParamQuery);
        log.debug((Object)("Query to use: " + query));
        log.debug((Object)"Using query in external DB , and collect result to list of row");
        List<HashMap<String, String>> rows = dbServiceExternalDB.useQuery(query);
        log.debug((Object)" group rows by groupColumnName and prepere column to JSON from other column who get to");
        log.debug((Object)"DYnamic Table from JSON");
        List<HashMap<String, String>> rowList = this.convertToGrupResult(rows, columnNameToGroupData, tableID, "json-map", columnNameToJSON);
        log.debug((Object)rowList.size());
        for (HashMap<String, String> hashMap : rowList) {
            log.debug((Object)hashMap.toString());
        }
        log.debug((Object)"Result data to datachooser");
        int endIndex = limit + start >= rowList.size() ? rowList.size() : limit + start;
        result.getData().addAll(rowList.subList(start, endIndex));
        log.debug((Object)("size " + rowList.size()));
        result.setTotal(rowList.size());
    }

    private String[] getIDFromVaraibales(Variable[] tableVar) {
        String[] result = new String[tableVar.length];
        for (int i = 0; i < tableVar.length; ++i) {
            result[i] = tableVar[i].getId();
        }
        return result;
    }

    private List<HashMap<String, String>> convertToGrupResult(List<HashMap<String, String>> rows, String[] groupByColumnName, String[] tableID, String jsonMapingName, String[] columnNameToJSON) {
        log.debug((Object)"convertToGrupResult");
        ArrayList<HashMap<String, String>> result = new ArrayList<HashMap<String, String>>();
        try {
            HashMap temp = new HashMap();
            ArrayList<String> tempKeyList = new ArrayList<String>();
            log.debug((Object)"chceck is any to group");
            if (groupByColumnName.length <= 0) {
                return rows;
            }
            log.debug((Object)"for one row");
            for (HashMap<String, String> row : rows) {
                String key = "";
                StringBuilder sBuilder = new StringBuilder("");
                ArrayList<String> groupColumnList = new ArrayList<String>(Arrays.asList(groupByColumnName));
                for (String string : groupByColumnName) {
                    if (row.containsKey(string)) {
                        sBuilder.append(row.get(string)).append(";;");
                        row.remove(string);
                        continue;
                    }
                    log.debug((Object)("No column:\t " + string));
                    groupColumnList.remove(string);
                }
                groupByColumnName = new String[groupColumnList.size()];
                for (int index = 0; index < groupColumnList.size(); ++index) {
                    groupByColumnName[index] = (String)groupColumnList.get(index);
                }
                key = sBuilder.toString();
                if (!temp.containsKey(key)) {
                    temp.put(key, new ArrayList());
                    tempKeyList.add(key);
                }
                ((List)temp.get(key)).add(row);
            }
            for (String tempKey : tempKeyList) {
                HashMap<String, String> tempHashMap = new HashMap<String, String>();
                String[] datachoseerColumn = tempKey.split(";;");
                for (int i = 0; i < datachoseerColumn.length; ++i) {
                    tempHashMap.put(groupByColumnName[i], datachoseerColumn[i]);
                }
                tempHashMap.put(jsonMapingName, this.createJSONFromSelectedData((List)temp.get(tempKey), tableID, columnNameToJSON));
                result.add(tempHashMap);
            }
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage());
            log.error((Object)e);
        }
        return result;
    }

    private String createJSONFromSelectedData(List<HashMap<String, String>> list, String[] tableId, String[] columnNameToJSON) {
        log.debug((Object)"createJSONFromSelectedData");
        ArrayList result = new ArrayList();
        if (tableId.length == columnNameToJSON.length) {
            for (HashMap<String, String> hashMapList : list) {
                HashMap<String, String> temp = new HashMap<String, String>();
                for (int index = 0; index < tableId.length; ++index) {
                    temp.put(tableId[index], hashMapList.get(columnNameToJSON[index]));
                }
                log.debug(temp);
                result.add(temp);
            }
        } else {
            System.out.println("ilo\u015bc kolumn do JSON niezgodna z ilo\u015bcia zmienych w tabeli dynamicznej");
            log.debug((Object)"ilo\u015bc kolumn do JSON niezgodna z ilo\u015bcia zmienych w tabeli dynamicznej");
        }
        return new Gson().toJson(result);
    }

    private Map<String, String> convertParamQuery(Variable[] paramQuery) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            for (Variable variable : paramQuery) {
                String param = this.variableToString(variable);
                result.put(variable.getId(), param);
            }
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage());
            log.error((Object)e);
        }
        return result;
    }

    private String variableToString(Variable variable) {
        if (variable.getValue() == null) {
            return "''";
        }
        if (variable.getType().toString().compareToIgnoreCase("string") == 0) {
            return "'" + (String)variable.getValue() + "'";
        }
        if (variable.getType().toString().compareToIgnoreCase("integer") == 0) {
            return String.valueOf((Long)variable.getValue());
        }
        if (variable.getType().toString().compareToIgnoreCase("float") == 0) {
            return String.valueOf((Double)variable.getValue());
        }
        if (variable.getType().toString().compareToIgnoreCase("datetime") == 0) {
            return "'" + String.valueOf((LocalDateTime)variable.getValue()) + "'";
        }
        if (variable.getType().toString().compareToIgnoreCase("date") == 0) {
            return "'" + ((LocalDate)variable.getValue()).toString() + "'";
        }
        if (variable.getType().toString().compareToIgnoreCase("boolean") == 0) {
            return ((Boolean)variable.getValue()).toString();
        }
        log.debug((Object)"No convert options: return ''");
        return "''";
    }

    private String processQuery(String queryRaw, String parametersRaw, Map<String, String> mapParamQuery) {
        if (parametersRaw == null) {
            return queryRaw;
        }
        String[] queryRawTab = queryRaw.split("[?]");
        String[] paramRawTab = parametersRaw.split(",");
        StringBuilder sBuilder = new StringBuilder("");
        for (int index = 0; index < queryRawTab.length; ++index) {
            sBuilder.append(queryRawTab[index]);
            if (index >= paramRawTab.length) continue;
            log.debug((Object)("contex param:\t " + mapParamQuery.get(paramRawTab[index]) == null ? "''" : mapParamQuery.get(paramRawTab[index])));
            sBuilder.append(mapParamQuery.get(paramRawTab[index]) == null ? "''" : mapParamQuery.get(paramRawTab[index]));
        }
        return sBuilder.toString();
    }
}

