/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.autotask;

import com.suncode.plugin.tools.categories.Categories;
import com.suncode.plugin.tools.until.CreatorSettings;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.IndexInfo;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.process.util.ProcessBuilderDefinition;
import com.suncode.pwfl.workflow.variable.Variable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Application
public class CreateNewProcessV2 {
    private static final Logger log = LoggerFactory.getLogger(CreateNewProcessV2.class);

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("create-new-process-v2")).name("application.create-new-process-v2.name")).description("application.create-new-process-v2.desc")).category(new Category[]{Categories.TOOLS_FOR_PROCESS})).icon((Icon)SilkIconPack.APPLICATION_GO)).parameter().id("package-id").name("application.create-new-process-v2.param.package-id.name").description("application.create-new-process-v2.param.package-id.desc").type((Type)Types.STRING).create()).parameter().id("process-def-id").name("application.create-new-process-v2.param.process-def-id.name").description("application.create-new-process-v2.param.process-def-id.desc").type((Type)Types.STRING).create()).parameter().id("process-info-output").name("application.create-new-process-v2.param.process-info-output.name").description("application.create-new-process-v2.param.process-info-output.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("create-empty-process").name("application.create-new-process-v2.param.create-empty-process.name").description("application.create-new-process-v2.param.create-empty-process.desc").type((Type)Types.BOOLEAN).optional().defaultValue((Object)true).create()).parameter().id("process-variables-const").name("application.create-new-process-v2.param.process-variables-const.name").description("application.create-new-process-v2.param.process-variables-const.desc").type((Type)Types.VARIABLE_ARRAY).optional().create()).parameter().id("process-variables-id-const").optional().name("application.create-new-process-v2.param.process-variables-id-const.name").description("application.create-new-process-v2.param.process-variables-id-const.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("process-variables-no-const").name("application.create-new-process-v2.param.process-variables-no-const.name").description("application.create-new-process-v2.param.process-variables-no-const.desc").type((Type)Types.VARIABLE_ARRAY).optional().create()).parameter().id("process-variables-id-no-const").name("application.create-new-process-v2.param.process-variables-id-no-const.name").description("application.create-new-process-v2.param.process-variables-id-no-const.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("attachment-document").name("application.create-new-process-v2.param.attachment-document.name").description("application.create-new-process-v2.param.attachment-document.desc").type((Type)Types.BOOLEAN).defaultValue((Object)false).create()).parameter().id("attachment-is-copy").name("application.create-new-process-v2.param.attachment-is-copy.name").description("application.create-new-process-v2.param.attachment-is-copy.desc").type((Type)Types.BOOLEAN).defaultValue((Object)false).create()).parameter().id("document-class-name").name("application.create-new-process-v2.param.document-class-name.name").description("application.create-new-process-v2.param.document-class-name.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("id-to-filter").name("application.create-new-process-v2.param.id-to-filter.name").description("application.create-new-process-v2.param.id-to-filter.desc").type((Type)Types.VARIABLE_ARRAY).optional().create()).parameter().id("regex").name("application.create-new-process-v2.param.regex.name").description("application.create-new-process-v2.param.regex.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("and-or").name("application.create-new-process-v2.param.and-or.name").description("application.create-new-process-v2.param.and-or.desc").type((Type)Types.BOOLEAN).optional().defaultValue((Object)true).create();
    }

    public void execute(@Param(value="package-id") String packageID, @Param(value="process-def-id") String processDefID, @Param(value="process-variables-const") Variable[] processVariableConst, @Param(value="process-variables-id-const") String[] processVariableIDConst, @Param(value="process-variables-no-const") Variable[] processVariableNoConst, @Param(value="process-variables-id-no-const") String[] processVariableIDNoConst, @Param(value="process-info-output") Variable processInfoOutput2, @Param(value="attachment-document") Boolean isAttachmentDocument, @Param(value="document-class-name") String[] documentClassNameParam, @Param(value="attachment-is-copy") Boolean isCopy, @Param(value="id-to-filter") Variable[] idToFilter, @Param(value="regex") String[] regexList, @Param(value="and-or") Boolean andOr, @Param(value="create-empty-process") Boolean createEmptyProcess, ActivityContextMap activityContextMap) {
        log.debug("Tworzenie nowego procesu");
        CreatorSettings creatorSet = new CreatorSettings();
        String creator = creatorSet.getUser();
        String creatorPassword = creatorSet.getPassword();
        ArrayList<String> newProcessIds = new ArrayList<String>();
        ProcessService processService = ServiceFactory.getProcessService();
        ProcessBuilderDefinition definition = new ProcessBuilderDefinition();
        definition.setPackageId(packageID);
        definition.setCreator(creator);
        definition.setCreatorPassword(creatorPassword);
        definition.setProcessDefId(processDefID);
        definition.setAutoStart(false);
        Map<String, Object> constForNewProcess = null;
        if (creator == null || creatorPassword == null) {
            log.debug("Brak ustawionego u\u017cytkowniak z has\u0142em ");
            return;
        }
        if (processVariableConst.length != processVariableIDConst.length || processVariableIDNoConst.length != processVariableNoConst.length) {
            log.debug("Parametry tablicowe s\u0105 r\u00f3\u017cnej dlugo\u015bci");
            return;
        }
        if (processVariableConst.length > 0) {
            constForNewProcess = this.prepareConstVariable(processVariableConst, processVariableIDConst);
        }
        if (processVariableNoConst.length > 0) {
            List<HashMap<String, Object>> varForManyProcess = this.prepareVariablesForNewProcesses(processVariableNoConst, processVariableIDNoConst, idToFilter, regexList, andOr, createEmptyProcess);
            for (HashMap<String, Object> hashMap : varForManyProcess) {
                log.debug("Create New Process");
                if (constForNewProcess != null) {
                    hashMap.putAll(constForNewProcess);
                }
                definition.setVariables(hashMap);
                try {
                    String processId = processService.createProcess(definition);
                    newProcessIds.add(processId);
                }
                catch (Exception e) {
                    log.error(e.getClass().getName() + " : " + e.getMessage(), (Throwable)e);
                    throw e;
                }
            }
        } else {
            log.debug("Create One New Process");
            definition.setVariables(constForNewProcess);
            try {
                String processId = processService.createProcess(definition);
                newProcessIds.add(processId);
            }
            catch (Exception e) {
                log.error(e.getClass().getName() + " : " + e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        log.debug("is empty " + newProcessIds.isEmpty());
        if (!newProcessIds.isEmpty()) {
            if (isAttachmentDocument.booleanValue() || processInfoOutput2 != null) {
                StringBuilder sbOutPut = new StringBuilder();
                Boolean firstLoop = true;
                List docs = FinderFactory.getDocumentFinder().getDocumentsFromProcess(activityContextMap.getProcessId(), new String[0]);
                for (String strNewProccessID : newProcessIds) {
                    log.debug("new process " + strNewProccessID);
                    if (isAttachmentDocument.booleanValue()) {
                        log.debug("Za\u0142\u0105czam dokumenty");
                        log.debug("Klasy dokuemnt\u00f3w" + String.valueOf(Arrays.asList(documentClassNameParam)));
                        List<String> documentsClassName = Arrays.asList(documentClassNameParam);
                        this.attachmentDocToNewProcess(strNewProccessID, creator, documentsClassName, isCopy, docs);
                    }
                    if (processInfoOutput2 == null) continue;
                    log.debug("Zapisuje nazwe utworzonego procesu");
                    if (processInfoOutput2.isArray()) {
                        if (!firstLoop.booleanValue()) {
                            sbOutPut.append(";");
                        }
                        sbOutPut.append(strNewProccessID);
                        firstLoop = false;
                        continue;
                    }
                    sbOutPut.append(strNewProccessID).append(" \t \n");
                }
                if (processInfoOutput2 != null) {
                    log.debug("Ustawiam zmienna wyjsciowa");
                    if (processInfoOutput2.isArray()) {
                        String[] arrayString = new String[]{sbOutPut.toString()};
                        processInfoOutput2.setValue((Object)arrayString);
                    } else {
                        processInfoOutput2.setValue((Object)sbOutPut.toString());
                    }
                }
            }
            for (String newProcessId : newProcessIds) {
                processService.startProcess(newProcessId);
            }
        }
    }

    private Map<String, Object> prepareConstVariable(Variable[] processVariable, String[] processVariableID) {
        log.debug("Przygotowuje stale zmienne");
        HashMap<String, Object> varMap = new HashMap<String, Object>();
        int indexVar = 0;
        for (Variable variable : processVariable) {
            if (variable.getValue() != null) {
                if (variable.isArray()) {
                    String str = this.convertArrayToString(variable);
                    log.debug(str);
                    varMap.put(processVariableID[indexVar], str);
                } else {
                    varMap.put(processVariableID[indexVar], this.checkAndConvertType(variable.getValue()));
                }
            }
            ++indexVar;
        }
        return varMap;
    }

    private String convertArrayToString(Variable variable) {
        Object[] objVar;
        log.debug("Konwersja tablicy do stringa");
        StringBuilder sb = new StringBuilder();
        Boolean firstChar = true;
        for (Object object : objVar = (Object[])variable.getValue()) {
            if (!firstChar.booleanValue()) {
                sb.append(";");
            }
            sb.append(this.checkAndConvertType(object));
            firstChar = false;
        }
        log.debug(sb.toString());
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    private List<HashMap<String, Object>> prepareVariablesForNewProcesses(Variable[] processVariable, String[] processVariableID, Variable[] idToFilter, String[] regexList, Boolean andOr, Boolean createEmptyProcess) {
        int indexVarForProcess;
        Object[] temp;
        Boolean filterOn = false;
        if (idToFilter != null && regexList != null && idToFilter.length > 0 && idToFilter.length == regexList.length) {
            filterOn = true;
        }
        log.debug("Przygotowanie zmienych dla roznych procesow");
        ArrayList<HashMap<String, Object>> variablesForProcess = new ArrayList<HashMap<String, Object>>();
        HashMap mapIndexVarToIndexNewPeocess = new HashMap();
        HashMap<String, Object> varMap = new HashMap<String, Object>();
        int indexVar = 0;
        for (Variable variable : processVariable) {
            if (variable.getValue() != null) {
                if (variable.isArray()) {
                    temp = null;
                    indexVarForProcess = 0;
                    for (Object object : temp = (Object[])variable.getValue()) {
                        if (variablesForProcess.size() <= indexVarForProcess) {
                            variablesForProcess.add(new HashMap());
                        }
                        ((HashMap)variablesForProcess.get(indexVarForProcess)).put(processVariableID[indexVar], this.checkAndConvertType(object));
                        ++indexVarForProcess;
                    }
                } else {
                    varMap.put(processVariableID[indexVar], this.checkAndConvertType(variable.getValue()));
                }
            }
            ++indexVar;
        }
        if (filterOn.booleanValue()) {
            int index;
            for (Variable variable : idToFilter) {
                if (variable.getValue() != null && variable.isArray()) {
                    temp = null;
                    indexVarForProcess = 0;
                    for (Object object : temp = (Object[])variable.getValue()) {
                        if (variablesForProcess.size() <= indexVarForProcess) {
                            variablesForProcess.add(new HashMap());
                        }
                        if (object == null) continue;
                        ((HashMap)variablesForProcess.get(indexVarForProcess)).put(variable.getId() + "filter", this.checkAndConvertType(object));
                        ++indexVarForProcess;
                    }
                }
                ++indexVar;
            }
            for (index = 0; index < variablesForProcess.size(); ++index) {
                void var13_23;
                Boolean bl = true;
                HashMap varForProcess = (HashMap)variablesForProcess.get(index);
                String filterType = andOr != false ? "AND" : "OR";
                log.debug("ustawiono filter na " + filterType);
                for (int indexFilter = 0; indexFilter < idToFilter.length; ++indexFilter) {
                    Variable variable = idToFilter[indexFilter];
                    String regex = regexList[indexFilter];
                    String newIdVariable = variable.getId() + "filter";
                    Object temp2 = varForProcess.get(newIdVariable);
                    String toEqRex = this.toString(temp2);
                    log.debug("Sprawdzam dopasowanie dla id: " + newIdVariable + " regex: " + regex);
                    Pattern pattern = Pattern.compile(regex);
                    Matcher matcher = pattern.matcher(toEqRex);
                    Boolean finded = matcher.find();
                    if (finded.booleanValue() && !andOr.booleanValue()) {
                        Boolean bl2 = true;
                        break;
                    }
                    if (!finded.booleanValue() && !andOr.booleanValue()) {
                        Boolean bl3 = false;
                        continue;
                    }
                    if (!finded.booleanValue() && andOr.booleanValue()) {
                        Boolean bl4 = false;
                        break;
                    }
                    if (!finded.booleanValue() || !andOr.booleanValue()) continue;
                    Boolean bl5 = true;
                }
                if (var13_23.booleanValue()) continue;
                log.debug("usuwam z listy");
                variablesForProcess.remove(index);
                Boolean bl6 = true;
                --index;
            }
            for (index = 0; index < variablesForProcess.size(); ++index) {
                for (Variable variable : idToFilter) {
                    String filterID = variable.getId() + "filter";
                    ((HashMap)variablesForProcess.get(index)).remove(filterID);
                }
            }
        } else {
            log.debug("Wy\u0142\u0105czony filtr lub nie poprawne ustawienia");
        }
        if (variablesForProcess.isEmpty() && (!varMap.isEmpty() || createEmptyProcess.booleanValue())) {
            variablesForProcess.add(new HashMap());
        }
        for (HashMap hashMap : variablesForProcess) {
            hashMap.putAll(varMap);
        }
        return variablesForProcess;
    }

    private Object checkAndConvertType(Object obj) {
        log.debug("Konwersja parametr\u00f3w");
        if (obj == null) {
            return "";
        }
        if (obj instanceof LocalDate) {
            return obj.toString();
        }
        if (obj instanceof LocalDateTime) {
            LocalDateTime timeDate = (LocalDateTime)obj;
            return timeDate.toDate();
        }
        if (obj instanceof Number) {
            return String.valueOf(obj);
        }
        return obj;
    }

    private String toString(Object obj) {
        log.debug("Konwersja parametr\u00f3w");
        if (obj == null) {
            return "";
        }
        if (obj instanceof LocalDateTime) {
            LocalDateTime timeDate = (LocalDateTime)obj;
            Date date = timeDate.toDate();
            return date.toString();
        }
        if (obj instanceof Number) {
            return String.valueOf(obj);
        }
        return obj.toString();
    }

    private void attachmentDocToNewProcess(String newProcessId, String userName, List<String> classesName, Boolean isCopy, List<WfDocument> docs) {
        log.debug("Za\u0142aczenie dokumentow");
        DocumentService documentService = ServiceFactory.getDocumentService();
        DocumentClassService documentClassService = ServiceFactory.getDocumentClassService();
        ArrayList<Long> classesId = new ArrayList<Long>();
        if (classesName != null) {
            for (String className : classesName) {
                log.debug("klasa:" + className);
                DocumentClass documentClass = documentClassService.getDocumentClass(className, new String[0]);
                if (documentClass == null) continue;
                classesId.add(documentClass.getId());
            }
        }
        for (WfDocument wfDocument : docs) {
            log.debug("Sprawdzanie czy sa dokumenty wymagane");
            if (classesName != null && !classesName.isEmpty() && !classesId.contains(wfDocument.getDocumentClassId())) continue;
            if (isCopy.booleanValue()) {
                log.debug("Tworze kopie");
                File file = new File(wfDocument.getFile().getFullPath());
                try {
                    FileInputStream is = new FileInputStream(file);
                    HashMap<Long, Object> idx = new HashMap<Long, Object>();
                    List indexesRaw = wfDocument.getIndexes();
                    for (IndexInfo indexInfo : indexesRaw) {
                        idx.put(indexInfo.getId(), indexInfo.getValue());
                    }
                    DocumentDefinition definition = new DocumentDefinition();
                    definition.setDocumentClassId(wfDocument.getDocumentClassId());
                    definition.setFileName(wfDocument.getFile().getFileName());
                    definition.setDescription(wfDocument.getFile().getDescription());
                    definition.setUserName(userName);
                    definition.setIndexes(idx);
                    definition.setInputStream((InputStream)is);
                    definition.setProcessId(newProcessId);
                    documentService.addDocument(definition);
                }
                catch (FileNotFoundException e) {
                    log.error(e.getClass().getSimpleName() + " : " + e.getMessage(), (Throwable)e);
                }
                continue;
            }
            log.debug("Podpinam istniejacy");
            documentService.attachDocumentToProcess(wfDocument, userName, newProcessId, null);
        }
    }
}

