window.TOOLS = {
    t: PW.I18N.createT('com.suncode.plugin-tools'),
    isUpdateFormActive: false,

    addComboboxClassList: function (idName, listenersFn, form, position, optionalParam) {
        form.addCombobox({
            id: idName,
            optional: optionalParam,
            remote: {
                url: "plugin/com.suncode.plugin-tools/docs/docClassList",
                fields: [
                    {
                        name: "docClassName",
                        type: "string"
                    }
                ]
            },
            valueField: "docClassName",
            displayField: "docClassName",
            sort: [{
                property: "docClassName",
                direction: "ASC"
            }],
            listeners: listenersFn
        }, position);
    },

    addComboboxClassIndexList: function (idName, documentClassName, listenersFn, form, position) {
        if (documentClassName != undefined) {
            form.addCombobox({
                id: idName,
                remote: {
                    url: "plugin/com.suncode.plugin-tools/docs/documentClassIndexList/" + documentClassName,
                    fields: [
                        {
                            name: "name",
                            type: "string"
                        },
                        {
                            name: "description",
                            type: "string"
                        },
                        {
                            name: "type",
                            type: "string"
                        }
                    ]
                },
                template: [
                    {
                        label: TOOLS.t("dpwe.document-class-index.name"),
                        field: "name"
                    },
                    {
                        label: TOOLS.t("dpwe.document-class-index.desc"),
                        field: "description"
                    },
                    {
                        label: TOOLS.t("dpwe.document-class-index.type"),
                        field: "type"
                    }
                ],
                valueField: "name",
                displayField: "name",
                sort: [{
                    property: "name",
                    direction: "ASC"
                }],
                listeners: listenersFn
            }, position);
        } else {
            form.addField({
                id: idName,
                listeners: listenersFn
            }, position);
        }
    },

    resetColumnValue: function (id, form) {
        arraySize = form.getArraySize(id);
        for (pos = 0; pos < arraySize; pos++) {
            form.setFieldValueInArray(id, pos, "");
        }
    },

    updateForm: function (timeoutMs) {

        if (!this.isUpdateFormActive) {
            this.isUpdateFormActive = true;
            setTimeout(function () {
                Ext4.ComponentQuery.query('suncodeform')[0].update();
                TOOLS.isUpdateFormActive = false;
            }, timeoutMs);
        }
    }
};