PWE.integrationComponent.registerApplication("tools.converter-word-pdf", {
	apiVersion : 2,
	buildForm : function(form) {
		form.addCombobox({
			id : "doc-class-name-src",
			remote : {
				url : "plugin/com.suncode.plugin-tools/docs/docClassList",
				fields : [ {
					name : "docClassName",
					type : "string"
				}, {
					name : "docClassDesc",
					type : "string"
				}]
			},
			valueField : "docClassName",
			displayField : "docClassName",
			sort : [ {
				property : "docClassName",
				direction : "ASC"
			} ]
		});

		form.addField({
			id : 'new-version',
			listeners : {
				change : function(value) {
					showHideParameters(form, value);
					form.resetValue("doc-class-name-to");
				}
			}
		});

		form.addCombobox({
			id : "doc-class-name-to",
			remote : {
				url : "plugin/com.suncode.plugin-tools/docs/docClassList",
				fields : [ {
					name : "docClassName",
					type : "string"
				}, {
					name : "docClassDesc",
					type : "string"
				}]
			},
			valueField : "docClassName",
			displayField : "docClassName",
			sort : [ {
				property : "docClassName",
				direction : "ASC"
			} ]
		});

		form.addField("use-alternative-renderer");
		
		showHideParameters(form,form.getValue("new-version", false));
	}
});

function showHideParameters(form,value){
	if (form.hasFunctionValue('new-version') || form.hasVariableValue('new-version')) {
		form.show("doc-class-name-to");
	} else if (value) {
		form.hide("doc-class-name-to");
	} else {
		form.show("doc-class-name-to");
	}
}
