
PWE.integrationComponent.registerApplication("send-sample-email-cfg-app", {
    apiVersion: 2,
    buildForm: function (form) {
		form.addField("subject");
		form.addField("email-content");
		form.addField("direct-addresses");
		form.addField("copy-addresses");
		form.addField("hidden-copy-addresses");
		form.addField("send-as-one");
        form.addField({
            id: "add-attachments",
            listeners: {
                change: function (value) {
                    if (value) {
                        form.show("document-source");
                    } else {
                        form.hide("document-source");
                        form.hide("attachClassTable");
                    }
                }
            }
        });

        form.addCombobox({
            id: "document-source",
            values: [
                {id: "documentClass", display: TOOLS.t("tools.document.class")},
                {id: "fileId", display: TOOLS.t("tools.file.id")}

            ],
            listeners: {
                change: function (value) {
                    showHideVariables(value);
                    attachClassTable.clear();
                }
            }
        });

        if (form.getValue('document-source') == null) {
            form.setValue('document-source', 'documentClass');
        }

        this.showHideVariables = function (comboboxValue) {

            switch (comboboxValue) {
                case "documentClass":
                    form.show("attachClassTable");
                    form.show("documets-class-id");
                    form.show("prefix");
                    form.show("filename-regexp");
                    form.hide("file-id");
                    break;
                case "fileId":
                    form.hide("attachClassTable");
                    form.show("file-id");
                    form.hide("prefix");
                    form.hide("documets-class-id");
                    form.hide("filename-regexp");
                    break;
            }
        };

        var attachClassTable = form.addTable({
            id: "attachClassTable",
            name: TOOLS.t("tools.tab-attach.name"),
            hidden: true
        })
        attachClassTable.addCombobox({
            id: "documets-class-id",
            remote: {
                url: "plugin/com.suncode.plugin-tools/docs/docClassList",
                fields: [
                    {
                        name: "docClassId",
                        type: "string"
                    },
                    {
                        name: "docClassName",
                        type: "string"
                    },
                    {
                        name: "docClassDesc",
                        type: "string"
                    }

                ]
            },
            valueField: "docClassName",
            displayField: "docClassName",
            sort: [{
                property: "docClassName",
                direction: "ASC"
            }],
            hidden: true
        });
        form.addField({
            id: "file-id",
            hidden: true
        });
        attachClassTable.addField({
            id: "filename-regexp",
            hidden: true
        });
        attachClassTable.addField({
            id: "prefix",
            hidden: true
        });

        if (form.getValue("add-attachments", false) == true) {
            showHideVariables(form.getValue('document-source'));
        }
        // save email param
        form.addField({
            id: 'save-content',
            listeners: {
                change: function (value) {
                    if (value || form.hasFunctionValue('save-content')  || form.hasVariableValue('save-content')) {
                        form.show("save-filename");
                        form.setNotEmpty("save-filename", true);
                        form.show("save-description");
                        form.show("save-doc-class-name");
                        form.setNotEmpty("save-doc-class-name", true);
                        form.show("save-atach-to-process");
                        form.show("save-add-header");
                        form.show("indexTable");
                        form.show("save-as-new-version");
                    } else {
                        form.hide("save-filename");
                        form.setNotEmpty("save-filename", false);
                        form.hide("save-description");
                        form.hide("save-doc-class-name");
                        form.setNotEmpty("save-doc-class-name", false);
                        form.hide("save-atach-to-process");
                        form.hide("save-add-header");
                        form.hide("indexTable");
                        form.hide("save-as-new-version");
                    }
                }
            }
        });
        form.addField('save-filename');
        form.addField('save-description');
        form.addCombobox({
            id: "save-doc-class-name",
            remote: {
                url: "plugin/com.suncode.plugin-tools/docs/docClassList",
                fields: [{
                        name: "docClassId",
                        type: "string"
                    },
                    {
                        name: "docClassName",
                        type: "string"
                    },
                    {
                        name: "docClassDesc",
                        type: "string"
                    }

                ]
            },
            valueField: "docClassName",
            displayField: "docClassName",
            sort: [{
                property: "docClassName",
                direction: "ASC"
            }],
            listeners:{
            	change: function(value){
            		indexComppoBoxApi.setUrl("plugin/com.suncode.plugin-tools/dpwe/docClassIndexList/"+value);
            	},
            	
            }
        });
        form.addField('save-atach-to-process');
        form.addField({
        	id:'save-add-header',
        	listeners: {
                change: function (value) {
                    if (value || form.hasFunctionValue('save-add-header')  || form.hasVariableValue('save-add-header')) 
                      {
                              form.show("save-cust-header-template-path");
                      } else 
                      {
                              form.hide("save-cust-header-template-path");
                       }
                }
        
        	}
        })
        form.addField('save-cust-header-template-path');
        form.addField("save-as-new-version");
            var indexTable = form.addTable({
                id: "indexTable",
                name: TOOLS.t("tools.tab-index.name"),
                hidden: true
            });
           var indexComppoBoxApi= indexTable.addCombobox({
            id: "index-name",
            remote: {
                url: "plugin/com.suncode.plugin-tools/dpwe/docClassIndexList/"+form.getValue('save-doc-class-name'),
                fields: [
					{
						name: "docClassIndexId",
						type: "string"
					},
					{
						name: "docClassIndexName",
						type: "string"
					},
					{
						name: "docClassIndexDesc",
						type: "string"
					},
					{
						name: "docClassIndexType",
						type: "string"
					}
				]
			},
			template: [
				{
					label: "",
					field: "docClassIndexName"
				},
				{
					label: "",
					field: "docClassIndexDesc"
				},
				{
					label: "",
					field: "docClassIndexType"
				},
			],
			valueField: "docClassIndexName",
			displayField: "docClassIndexName",
			sort: [{
				property: "docClassIndexName",
				direction: "ASC"
			}]
           })
    	indexTable.addField("index-value");
        form.addLabel(TOOLS.t("tools.server_conf.display"))
        form.addField("host_server");
        form.addField("smtp-port");
        form.addField("smtp-auth-enable");
        form.addField("source-mail");
        form.addField("email-user-login");
        form.addField("email-user-password");
        form.addField("ssl-enable");
        form.addField("tls-enable");
        
        if (form.getValue("save-content", false) == true || form.hasFunctionValue('save-content')  || form.hasVariableValue('save-content')) {
            form.show("save-filename");
            form.setNotEmpty("save-filename", true);
            form.show("save-description");
            form.show("save-doc-class-name");
            form.setNotEmpty("save-doc-class-name", true);
            form.show("save-atach-to-process");
            form.show("save-add-header");
            form.show("indexTable");
            form.show("save-as-new-version");
            if (form.getValue("save-add-header", false) == true || form.hasFunctionValue('save-add-header')  || form.hasVariableValue('save-add-header')) 
            {
                    form.show("save-cust-header-template-path");
            }
        } else {
            form.hide("save-filename");
            form.setNotEmpty("save-filename", false);
            form.hide("save-description");
            form.hide("save-doc-class-name");
            form.setNotEmpty("save-doc-class-name", false);
            form.hide("save-atach-to-process");
            form.hide("save-add-header");
            form.hide("indexTable");
            form.hide("save-as-new-version");
            form.hide("save-cust-header-template-path");
        };
    }
});





