PWE.integrationComponent.registerApplication("send-advance-email-app", {
    apiVersion: 2,
    buildForm: function (form) {
        form.addCombobox({
            id: "email-config-id",
            optional: false,
            values: getEmailConfigs().map(({id, name}) => ({id: id.toString(), display: name}))
        });

        form.addField({
            id: "is-tempalte-name",
            hidden: true
        });
        form.addCombobox({
            id: "comboMode",
            name: TOOLS.t("tools.combo-mode.name"),
            value: form.getValue("is-tempalte-name", false) ? "name" : "path",
            values: [{
                    id: "path",
                    display: TOOLS.t("tools.combo-mode.display.path"),
                    description: TOOLS.t("tools.combo-mode.desc.path")
                },
                {
                    id: "name",
                    display: TOOLS.t("tools.combo-mode.display.name"),
                    description: TOOLS.t("tools.combo-mode.desc.name")
                }
            ],
            listeners: {
                change: function (value) {
                    position = form.getFieldPosition("template-path");
                    form.removeField("template-path")
                    if (value == "path") {
                        form.addField({
                            id: "template-path",
                            name: TOOLS.t("tools.template-path.name"),
                            description: TOOLS.t("tools.combo-mode.desc.path")
                        }, position);
                        form.setValue("is-tempalte-name", false);
                        form.setValue("template-path", "");
                    } else {
                        form.addField({
                            id: "template-path",
                            name: TOOLS.t("tools.template-name.name"),
                            description: TOOLS.t("tools.combo-mode.desc.name")
                        }, position);
                        form.setValue("is-tempalte-name", true);
                        form.setValue("template-path", "");
                    }
                }
            }
        });
        if (form.getValue("is-tempalte-name", false) == true) {
            form.addField({
                id: "template-path",
                name: TOOLS.t("tools.template-name.name"),
                description: TOOLS.t("tools.combo-mode.desc.name")
            });
        } else {
            form.addField({
                id: "template-path",
                name: TOOLS.t("tools.template-path.name"),
                description: TOOLS.t("tools.combo-mode.desc.path")
            });
        }
        form.addField({
            id: "subject"
        });
        form.addField({
            id: "direct-addresses"
        });
        form.addField({
            id: "copy-addresses"
        });
        form.addField({
            id: "hidden-copy-addresses"
        });
        // table
        table = form.addTable({
            id: "tabVariable",
            name: TOOLS.t("tools.tab-variable.name"),
            description: TOOLS.t("tools.tab-variable.desc")
        });
        table.addField("variables-key");
        table.addField("variables-value");

        form.addField({
            id: "send-as-one"
        });
        form.addField({
            id: "info-success-send"
        });
        form.addField({
            id: "info-failure-send"
        });
        form.addField({
            id: "comment-report"
        });
        form.addField({
            id: "add-attachments",
            listeners: {
                change: function (value) {
                    if (value) {
                        form.show("document-source");
                        if (form.getValue("document-source") === "documentClass") {
                            form.show("attachClassTable");
                            form.show("documets-class-id");
                            form.show("prefix");
                            form.show("filename-regexp");
                        } else {
                            form.show("file-id");
                            form.setNotEmpty("file-id", true);
                        }
                    } else {
                        form.hide("document-source");
                        if (form.getValue("document-source") === "documentClass") {
                            form.hide("attachClassTable");
                            form.hide("documets-class-id");
                            form.hide("prefix");
                            form.hide("filename-regexp");
                        } else {
                            form.hide("file-id");
                            form.setNotEmpty("file-id", false);
                        }
                    }
                }
            }
        });

        form.addCombobox({
            id: "document-source",
            values: [
                {id: "documentClass", display: TOOLS.t("tools.document.class")},
                {id: "fileId", display: TOOLS.t("tools.file.id")}

            ],
            listeners: {
                change: function (value) {
                    showHideVariables(value);
                    attachClassTable.clear();
                }
            },
            hidden: form.getValue("add-attachments") === false
        });

        if (form.getValue("add-attachments") === true && form.getValue('document-source') == null) {
            form.setValue('document-source', 'documentClass');
        }

        this.showHideVariables = function (comboboxValue) {
            switch (comboboxValue) {
                case "documentClass":
                    form.show("attachClassTable");
                    form.show("documets-class-id");
                    form.show("prefix");
                    form.show("filename-regexp");
                    form.hide("file-id");
                    form.setNotEmpty("file-id", false);
                    break;
                case "fileId":
                    form.hide("attachClassTable");
                    form.show("file-id");
                    form.setNotEmpty("file-id", true);
                    form.hide("prefix");
                    form.hide("documets-class-id");
                    form.hide("filename-regexp");
                    break;
            }
        };

        var attachClassTable = form.addTable({
            id: "attachClassTable",
            name: TOOLS.t("tools.tab-attach.name"),
            hidden: true
        })
        attachClassTable.addCombobox({
            id: "documets-class-id",
            remote: {
                url: "plugin/com.suncode.plugin-tools/docs/docClassList",
                fields: [
                    {
                        name: "docClassId",
                        type: "string"
                    },
                    {
                        name: "docClassName",
                        type: "string"
                    },
                    {
                        name: "docClassDesc",
                        type: "string"
                    }

                ]
            },
            valueField: "docClassName",
            displayField: "docClassName",
            sort: [{
                property: "docClassName",
                direction: "ASC"
            }],
            hidden: form.getValue('document-source') !== "documentClass",
        });
        form.addField({
            id: "file-id",
            hidden: form.getValue("add-attachments") !== true || form.getValue('document-source') !== "fileId",
            notEmpty: form.getValue("add-attachments") === true && form.getValue('document-source') === "fileId",
        });
        attachClassTable.addField({
            id: "filename-regexp",
            hidden: form.getValue('document-source') !== "documentClass",
        });
        attachClassTable.addField({
            id: "prefix",
            hidden: form.getValue('document-source') !== "documentClass",
        });

        if (form.getValue("add-attachments", false) == true) {
            showHideVariables(form.getValue('document-source'));
        }
        // save email param
        form.addField({
            id: 'save-content',
            listeners: {
                change: function (value) {
                    if (value || form.hasFunctionValue('save-content')  || form.hasVariableValue('save-content')) {
                        form.show("save-filename");
                        form.setNotEmpty("save-filename", true);
                        form.show("save-description");
                        form.show("save-doc-class-name");
                        form.setNotEmpty("save-doc-class-name", true);
                        form.show("save-atach-to-process");
                        form.show("save-add-header");
                        if (form.getValue("save-add-header") === true) {
                            form.show("save-cust-header-template-path");
                        }
                        form.show("indexTable");
                        form.show("save-as-new-version");
                    } else {
                        form.hide("save-filename");
                        form.setNotEmpty("save-filename", false);
                        form.hide("save-description");
                        form.hide("save-doc-class-name");
                        form.setNotEmpty("save-doc-class-name", false);
                        form.hide("save-atach-to-process");
                        form.hide("save-add-header");
                        if (form.getValue("save-add-header") === true) {
                            form.hide("save-cust-header-template-path");
                        }
                        form.hide("indexTable");
                        form.hide("save-as-new-version");
                    }
                }
            }
        });
        form.addField('save-filename');
        form.addField('save-description');
        form.addCombobox({
            id: "save-doc-class-name",
            remote: {
                url: "plugin/com.suncode.plugin-tools/docs/docClassList",
                fields: [{
                        name: "docClassId",
                        type: "string"
                    },
                    {
                        name: "docClassName",
                        type: "string"
                    },
                    {
                        name: "docClassDesc",
                        type: "string"
                    }

                ]
            },
            valueField: "docClassName",
            displayField: "docClassName",
            sort: [{
                property: "docClassName",
                direction: "ASC"
            }],
            listeners:{
            	change: function(value){
            		indexComppoBoxApi.setUrl("plugin/com.suncode.plugin-tools/dpwe/docClassIndexList/"+value);
            	},
            	
            }
        });
        form.addField('save-atach-to-process');
        form.addField({
        	id:'save-add-header',
        	listeners: {
                change: function (value) {
                    if (value || form.hasFunctionValue('save-add-header')  || form.hasVariableValue('save-add-header')) 
                      {
                              form.show("save-cust-header-template-path");
                      } else 
                      {
                              form.hide("save-cust-header-template-path");
                       }
                }
        
        	}
        })
        form.addField({
            id: 'save-cust-header-template-path',
            hidden: form.getValue('save-add-header') !== true
        });
        form.addField("save-as-new-version");
            var indexTable = form.addTable({
                id: "indexTable",
                name: TOOLS.t("tools.tab-index.name"),
                hidden: true
            });
           var indexComppoBoxApi= indexTable.addCombobox({
            id: "index-name",
            remote: {
                url: "plugin/com.suncode.plugin-tools/dpwe/docClassIndexList/"+form.getValue('save-doc-class-name'),
                fields: [
					{
						name: "docClassIndexId",
						type: "string"
					},
					{
						name: "docClassIndexName",
						type: "string"
					},
					{
						name: "docClassIndexDesc",
						type: "string"
					},
					{
						name: "docClassIndexType",
						type: "string"
					}
				]
			},
			template: [
				{
					label: "",
					field: "docClassIndexName"
				},
				{
					label: "",
					field: "docClassIndexDesc"
				},
				{
					label: "",
					field: "docClassIndexType"
				},
			],
			valueField: "docClassIndexName",
			displayField: "docClassIndexName",
			sort: [{
				property: "docClassIndexName",
				direction: "ASC"
			}]
	    })
	    indexTable.addField("index-value");
	    if (form.getValue("save-content", false) == true || form.hasFunctionValue('save-content')  || form.hasVariableValue('save-content')) {
	        form.show("save-filename");
	        form.setNotEmpty("save-filename", true);
	        form.show("save-description");
	        form.show("save-doc-class-name");
	        form.setNotEmpty("save-doc-class-name", true);
	        form.show("save-atach-to-process");
	        form.show("save-add-header");
	        form.show("indexTable");
	        form.show("save-as-new-version");
	        if (form.getValue("save-add-header", false) == true || form.hasFunctionValue('save-add-header')  || form.hasVariableValue('save-add-header')) 
            {
                    form.show("save-cust-header-template-path");
            }
	    } else {
	        form.hide("save-filename");
	        form.setNotEmpty("save-filename", false);
	        form.hide("save-description");
	        form.hide("save-doc-class-name");
	        form.setNotEmpty("save-doc-class-name", false);
	        form.hide("save-atach-to-process");
	        form.hide("save-add-header");
	        form.hide("indexTable");
	        form.hide("save-as-new-version");
	        form.hide("save-cust-header-template-path");
	    }
    }
});

function getEmailConfigs() {
    let data;
    jQuery.ajax({
        url: PW.getAbsolutePath('plugin/com.suncode.plugin-tools/email/configs'),
        contentType: "application/json",
        async: false,
        method: 'GET',
        success: function (response) {
            data = response.data;
        },
    });
    return data;
}