PWE.integrationComponent.registerFormAction("tools.screenshot", {
    apiVersion: 2,
    buildForm: function (form) {
        form.addField("filename");

        form.addCombobox({
            id: "format",
            valueField: "id",
            displayField: "display",
            fields: [
                {name: "id", type: "string"},
                {name: "display", type: "string"}
            ],
            values: [
                {id: "pdf", display: "PDF"},
                {id: "png", display: "PNG"},
                {id: "jpg", display: "JPG"}
            ],
            listeners: {
                change: function () {
                    toggleFormatOptions(form);
                }
            }
        });

        form.addField("jpegQuality");

        form.addCombobox({
            id: "pdfCompression",
            valueField: "id",
            displayField: "display",
            fields: [
                {name: "id", type: "string"},
                {name: "display", type: "string"}
            ],
            values: [
                {id: "none", display: "NONE"},
                {id: "slow", display: "SLOW"},
                {id: "medium", display: "MEDIUM"},
                {id: "fast", display: "FAST"}
            ]
        });

        form.addCombobox({
            id: "orientation",
            valueField: "id",
            displayField: "display",
            fields: [
                {name: "id", type: "string"},
                {name: "display", type: "string"}
            ],
            values: [
                {id: "portrait", display: TOOLS.t("tools.pdf-orientation.portrait")},
                {id: "landscape", display: TOOLS.t("tools.pdf-orientation.landscape")}
            ]
        });

        form.addCombobox({
            id: "fitTo",
            valueField: "id",
            displayField: "display",
            fields: [
                {name: "id", type: "string"},
                {name: "display", type: "string"}
            ],
            values: [
                {id: "pagewidth", display: TOOLS.t("tools.pdf-fitto.pagewidth")},
                {id: "pageheight", display: TOOLS.t("tools.pdf-fitto.pageheight")}
            ]
        });

        form.addField({
            id: "includeComments",
            listeners: {
                change: (value) => value ? form.show("expandComments") : form.hide("expandComments")
            }
        });
        form.addField("includeTabBar");
        form.addField({
            id: "expandComments",
            hidden: !form.getValue("includeComments")
        });
        form.addField("expandTables");

        toggleFormatOptions(form);
    },

    validateForm: function (form) {
        let isValid = true;
        const jpegQuality = form.getValue("jpegQuality");

        if (typeof jpegQuality === "number" && (jpegQuality <= 0 || jpegQuality > 1)) {
            form.markError("jpegQuality");
            isValid = false;
        }

        return isValid;
    }
});

function toggleFormatOptions(form) {
    const format = form.getValue("format");

    switch (format) {
        case "pdf": {
            form.show("fitTo");
            form.show("orientation");
            form.show("pdfCompression");
            form.hide("jpegQuality");
            break;
        }
        case "jpg": {
            form.show("jpegQuality");
            form.hide("fitTo");
            form.hide("orientation");
            form.hide("pdfCompression");
            break;
        }
        case "png": {
            form.hide("jpegQuality");
            form.hide("fitTo");
            form.hide("orientation");
            form.hide("pdfCompression");
            break;
        }
        default: {
            form.show("jpegQuality");
            form.show("fitTo");
            form.show("orientation");
            form.show("pdfCompression");
        }
    }
}