PWE.integrationComponent.registerApplication('tools.save-files-to-disk-dual', {
    apiVersion: 2,
    buildForm: function (form) {
        buildForm(form)
    }
});

PWE.integrationComponent.registerVariablesSetter('tools.save-files-to-disk-dual', {
    apiVersion: 2,
    buildForm: function (form) {
        buildForm(form)
    }
});

function buildForm(form) {
	addDownloadingFilesSettings(form);
	addSavingFilesSettings(form);
}

function addDownloadingFilesSettings(form) {
	var downloadingFilesSettings = form.addFieldSet({
		id: "downloading-files-settings-fs",
		collapsible: false,
		collapsed: false,
		title: TOOLS.t("tools.save-files-to-disk-dual.downloading-files-settings")
	});
	downloadingFilesSettings.addCombobox({
		id: "filesDownloadingSource",
		values: [
			{ id: "PROCESS", display: TOOLS.t("tools.save-files-to-disk-dual.process") },
			{ id: "ARCHIVE", display: TOOLS.t("tools.save-files-to-disk-dual.archive") },
			{ id: "FILEIDS", display: TOOLS.t("tools.save-files-to-disk-dual.fileids") }
		],
		listeners: {
			change: function(value) {
				if (value === "PROCESS") {						
					downloadingFilesSettings.setNotEmpty("documentClassNamesProcess", false);
					downloadingFilesSettings.show("documentClassNamesProcess");
					downloadingFilesSettings.setNotEmpty("documentClassNameArchive", false);
					downloadingFilesSettings.hide("documentClassNameArchive");
					downloadingFilesSettings.hide("indexTable");
					downloadingFilesSettings.setNotEmpty("fileIdList", false);
					downloadingFilesSettings.hide("fileIdList");
					downloadingFilesSettings.show("filenameFilter");
				} else if (value === "ARCHIVE") {
					downloadingFilesSettings.setNotEmpty("documentClassNameArchive", true);
					downloadingFilesSettings.show("documentClassNameArchive");
					downloadingFilesSettings.show("indexTable");
					downloadingFilesSettings.setNotEmpty("documentClassNamesProcess", false);
					downloadingFilesSettings.hide("documentClassNamesProcess");
					downloadingFilesSettings.setNotEmpty("fileIdList", false);
					downloadingFilesSettings.hide("fileIdList");
					downloadingFilesSettings.show("filenameFilter");
				} else if (value === "FILEIDS") {
					downloadingFilesSettings.setNotEmpty("fileIdList", true);
					downloadingFilesSettings.show("fileIdList");
					downloadingFilesSettings.setNotEmpty("documentClassNamesProcess", false);
					downloadingFilesSettings.hide("documentClassNamesProcess");
					downloadingFilesSettings.setNotEmpty("documentClassNameArchive", false);
					downloadingFilesSettings.hide("documentClassNameArchive");
					downloadingFilesSettings.hide("indexTable");
					downloadingFilesSettings.hide("filenameFilter");
				} else if (downloadingFilesSettings.hasFunctionValue("filesDownloadingSource") || 
						downloadingFilesSettings.hasVariableValue("filesDownloadingSource")) {					
					downloadingFilesSettings.setNotEmpty("documentClassNamesProcess", false);
					downloadingFilesSettings.show("documentClassNamesProcess");
					downloadingFilesSettings.setNotEmpty("documentClassNameArchive", false);
					downloadingFilesSettings.show("documentClassNameArchive");
					downloadingFilesSettings.show("indexTable");
					downloadingFilesSettings.setNotEmpty("fileIdList", false);
					downloadingFilesSettings.show("fileIdList");
					downloadingFilesSettings.show("filenameFilter");
				} else {
					downloadingFilesSettings.setNotEmpty("documentClassNameProcess", false);
					downloadingFilesSettings.hide("documentClassNameProcess");
					downloadingFilesSettings.setNotEmpty("documentClassNameArchive", false);
					downloadingFilesSettings.hide("documentClassNameArchive");
					downloadingFilesSettings.hide("indexTable");
					downloadingFilesSettings.setNotEmpty("fileIdList", false);
					downloadingFilesSettings.hide("fileIdList");
					downloadingFilesSettings.hide("filenameFilter");
				}
			}
		}
	});
	TOOLS.addComboboxClassList("documentClassNamesProcess", null, downloadingFilesSettings, null, false);
	buildComboboxClassAndIndexList(downloadingFilesSettings);
	downloadingFilesSettings.addField("fileIdList");
	downloadingFilesSettings.addField("filenameFilter");
	afterDownloadFieldSetLoad(downloadingFilesSettings);
}

function addSavingFilesSettings(form) {
	var savingFilesSettings = form.addFieldSet({
		id: "saving-files-settings-fs",
		collapsible: false,
		collapsed: false,
		title: TOOLS.t("tools.save-files-to-disk-dual.saving-files-settings")
	});
	savingFilesSettings.addField("directory");
	savingFilesSettings.addField("fileName");
}

function buildComboboxClassAndIndexList(form) {
	TOOLS.addComboboxClassList("documentClassNameArchive", {
		change: function (value) {
            var position = form.getFieldPosition("indexName");
            form.removeField("indexName");
            if (form.hasVariableValue("documentClassNameArchive") || form.hasFunctionValue("documentClassNameArchive")) {
                indexTable.addField("indexName", position)
            } else {
            	TOOLS.addComboboxClassIndexList("indexName", value, null, indexTable, 0);
            }
            TOOLS.resetColumnValue("indexName", form);
        }
	}, form, null);
	var indexTable = form.addTable({
        id: "indexTable",
        name: TOOLS.t("tools.save-files-to-disk-dual.index-table")
    });
	TOOLS.addComboboxClassIndexList("indexName", form.getValue("documentClassNameArchive"), null, indexTable, 0);
    if (form.hasVariableValue("documentClassNameArchive") || form.hasFunctionValue("documentClassNameArchive")) {
        indexTable.addField("indexName")
    } else {
        TOOLS.addComboboxClassIndexList("indexName", form.getValue("documentClassNameArchive"), null, indexTable, 0);
    }
    indexTable.addField("indexValue");
}

function afterDownloadFieldSetLoad(downloadingFilesSettings) {
	if (downloadingFilesSettings.getValue("filesDownloadingSource") === "PROCESS") {					
		downloadingFilesSettings.setNotEmpty("documentClassNamesProcess", false);
		downloadingFilesSettings.show("documentClassNamesProcess");
		downloadingFilesSettings.setNotEmpty("documentClassNameArchive", false);
		downloadingFilesSettings.hide("documentClassNameArchive");
		downloadingFilesSettings.hide("indexTable");
		downloadingFilesSettings.setNotEmpty("fileIdList", false);
		downloadingFilesSettings.hide("fileIdList");
		downloadingFilesSettings.show("filenameFilter")
	} else if (downloadingFilesSettings.getValue("filesDownloadingSource") === "ARCHIVE") {
		downloadingFilesSettings.setNotEmpty("documentClassNameArchive", true);
		downloadingFilesSettings.show("documentClassNameArchive");
		downloadingFilesSettings.show("indexTable");
		downloadingFilesSettings.setNotEmpty("documentClassNamesProcess", false);
		downloadingFilesSettings.hide("documentClassNamesProcess");
		downloadingFilesSettings.setNotEmpty("fileIdList", false);
		downloadingFilesSettings.hide("fileIdList");
		downloadingFilesSettings.show("filenameFilter")
	} else if (downloadingFilesSettings.getValue("filesDownloadingSource") === "FILEIDS") {
		downloadingFilesSettings.setNotEmpty("fileIdList", true);
		downloadingFilesSettings.show("fileIdList");
		downloadingFilesSettings.setNotEmpty("documentClassNamesProcess", false);
		downloadingFilesSettings.hide("documentClassNamesProcess");
		downloadingFilesSettings.setNotEmpty("documentClassNameArchive", false);
		downloadingFilesSettings.hide("documentClassNameArchive");
		downloadingFilesSettings.hide("indexTable");
		downloadingFilesSettings.hide("filenameFilter")
	} else if (downloadingFilesSettings.hasFunctionValue("filesDownloadingSource") || 
			downloadingFilesSettings.hasVariableValue("filesDownloadingSource")) {
		downloadingFilesSettings.setNotEmpty("documentClassNamesProcess", false);
		downloadingFilesSettings.show("documentClassNamesProcess");
		downloadingFilesSettings.setNotEmpty("documentClassNameArchive", false);
		downloadingFilesSettings.show("documentClassNameArchive");
		downloadingFilesSettings.show("indexTable");
		downloadingFilesSettings.setNotEmpty("fileIdList", false);
		downloadingFilesSettings.show("fileIdList");
		downloadingFilesSettings.show("filenameFilter")
	} else {
		downloadingFilesSettings.setNotEmpty("documentClassNamesProcess", false);
		downloadingFilesSettings.hide("documentClassNamesProcess");
		downloadingFilesSettings.setNotEmpty("documentClassNameArchive", false);
		downloadingFilesSettings.hide("documentClassNameArchive");
		downloadingFilesSettings.hide("indexTable");
		downloadingFilesSettings.setNotEmpty("fileIdList", false);
		downloadingFilesSettings.hide("fileIdList");
		downloadingFilesSettings.hide("filenameFilter")
	}
}