PW.FormActions.create('tools.translate-money', {
    init: function () {
        this.txtVariable = this.get("veriable-to-set");
    },
    variableInit: function (variable) {
        this.variable = variable;
    },
    enable: function () {
        this.variable.on("change", this.translate, this);
        this.translate();
    },
    disable: function () {
        this.variable.off("change", this.translate, this);
    },
    translate: function () {
        let value = this.variable.getValue();
        let variableId = this.txtVariable.getId();

        if (value === null || value.length === 0) {
            VariableService.setValue(variableId, "");
            return;
        }

        jQuery.ajax({
            url: 'plugin/com.suncode.plugin-tools/money',
            type: "GET",
            data: {
                money: value
            },
            success: function (result) {
                let decodedPlusURL = decodeURIComponent(result);
                let info = decodedPlusURL.replace(
                    new RegExp("\\+", 'g'), " ");
                VariableService.setValue(variableId, info);
                return true;
            },
            error: function () {
                console.log("error ajax tools.translate-money");
                return false;
            }
        });
    }
});