PW.FormActions.create('tools-get-document-class-in-process', {

    init: function () {
    	this.table = VariableSetService.get(this.get("tableId"));
    },
    enable: function () {  
    	if (this.target.type != "BUTTON") {
    		this.loadData()
		}
    },
    defaultActions: {
        button: function (button) {
            this.loadData()
        }
    },
    loadData: function () {
        var me = this;
        FormService.mask();
        jQuery.ajax({
            url: 'plugin/com.suncode.plugin-tools/docs/info/class',
            type: "POST",
            data: {
                processId: processId,
                activityId: activityId
            },
            success: function (result) {
                if (result.total>0) {
                	VariableSetService.clear(me.table);
					me.setData(me,result.data);
					VariableSetService.save(me.table);
                } else {
					MessageService.showFailure(TOOLS.t("tools.error.process.missing.documents.label"));
				}
            },
            error: function (e) {
            	MessageService.showFailure(TOOLS.t("tools.error.process.document.label"));
                Logger.error(e);
                return false;
            },
			complete: function () {
				FormService.unmask();
			}
        });
    },
    setData: function(me, data){
		PW.each(data, function (item, rowIndex) {
			VariableSetService.addRow(me.table);
			if (me.get("className")) {
				VariableSetService.setValue(me.table, rowIndex, me.get("className").getId(), item.name);
			}
			if (me.get("classId")) {
				VariableSetService.setValue(me.table, rowIndex, me.get("classId").getId(), item.id);
			}
		});
	}
});