PW.FormActions.create('tools.insert-html', {

    init: function () {
        this.divId = Ext4.id();
    },

    enable: function () {

        const KEYS = {
            BEGINNING_OF_THE_FORM: 'beginningOfTheForm',
            END_OF_THE_FORM: 'endOfTheForm',
            BEFORE_VARIABLE: 'beforeVariable',
            AT_VARIABLE_HEIGHT: 'atVariableHeight',
            AFTER_VARIABLE: 'afterVariable',
            BEFORE_TABLE: 'beforeTable',
            AT_TABLE_HEIGHT: 'atTableHeight',
            AFTER_TABLE: 'afterTable',
        }

        var html = this.get("html");
        var positionOnForm = this.get("positionOnForm");
        var variableId = this.get("variable") == null ? '' : this.get("variable").getId();
        var tableId = this.get("tableId");

        html = '<div id ="' + this.divId + '">' + html + '</div>';

        switch (positionOnForm) {
            case KEYS.BEGINNING_OF_THE_FORM:
                FormService.insertHtml(html, '', true, '');
                break;
            case KEYS.END_OF_THE_FORM:
                FormService.insertHtml(html, '', false, '');
                break;
            case KEYS.BEFORE_VARIABLE:
                FormService.insertHtml(html, variableId, true, '');
                break;
            case KEYS.AT_VARIABLE_HEIGHT:
                FormService.insertHtml(html, variableId, '', true);
                break;
            case KEYS.AFTER_VARIABLE:
                FormService.insertHtml(html, variableId, false, '');
                break;
            case KEYS.BEFORE_TABLE:
                FormService.insertHtml(html, tableId, true, '');
                break;
            case KEYS.AT_TABLE_HEIGHT:
                FormService.insertHtml(html, tableId, '', true);
                break;
            case KEYS.AFTER_TABLE:
                FormService.insertHtml(html, tableId, false, '');
                break;
            default:
                FormService.insertHtml(html, '', true, '');
                break;
        }
    },

    disable: function () {

        jQuery('#' + this.divId).remove();
        TOOLS.updateForm(1);
    }
});