PW.FormActions.create('init-variable-jo', {
    init: function () {
        this.variableName = this.get("variable-name");
        this.variableSymbol = this.get("variable-symbol");
    },
    enable: function () {
        this.fetchData();
    },
    fetchData: function () {
        let variableName = this.variableName;
        let variableSymbol = this.variableSymbol;

        jQuery.ajax({
            url: 'plugin/com.suncode.plugin-tools/init/jo',
            type: "GET",
            success: function (result) {
                let resultName = decodeURIComponent(result['name']);
                let resultSymbol = decodeURIComponent(result['symbol']);

                if (variableName) {
                    if (variableName.type.isArray) {
                        variableName.setValue(resultName.split(','));
                    } else {
                        variableName.setValue(resultName);
                    }
                }

                if (variableSymbol) {
                    if (variableSymbol.type.isArray) {
                        variableSymbol.setValue(resultSymbol.split(','));
                    } else {
                        variableSymbol.setValue(resultSymbol);
                    }
                }

                return true;
            },
            error: function () {
                console.log("error ajax init-variable-jo");
                return false;
            }
        });
    }
});