const linkPartSeparator = "=()=";

PW.FormActions.create("hyperlink-column", {
    variableSetInit: function (variableSet) {
        this.table = VariableSetService.get(variableSet.getId());
        this.linkFunctions = [this.get("href-link-function")].concat(this.get("href-link-function-array")).filter(element => element !== null);
        this.nameFunctions = [this.get("href-name-function")].concat(this.get("href-name-function-array")).filter(element => element !== null);
        this.columnIds = [this.get("column-id")].concat(this.get("column-id-array")).filter(element => element !== null);
        this.targets = [this.get("href-target")].concat(this.get("href-target-array")).filter(element => element !== null);
    },
    enable: function () {
        if (this.checkIfOldParametersExist()) {
            this.setWithOldParameters();
        } else {
            this.setWithFunctionParameters();
        }
    },
    disable: function () {
        for (let i = 0; i < this.columnIds.length; i++) {
            VariableSetService.removeRenderers(this.table, [this.columnIds[i].getId()]);
        }
    },
    defaultActions: {
        variableSet: function (variableSet, added, updated) {
            if (this.checkIfOldParametersExist()) {
                return;
            }

            if (added.length !== 0) {
                this.setRows(added, true);
            }
            if (updated.length !== 0) {
                this.setRows(updated, false);
            }
        }
    },
    setRows: function (rows, isAdded) {
        if (!PW.isEmpty(rows)) {
            PW.each(rows, function (row) {
                if (isAdded || this.shouldUpdate(row)) {
                    this.setRow(row.index);
                }
            }, this);
        }
    },
    setRow: function (index) {
        this.setContextVariable("row-index", index);
        for (let i = 0; i < this.columnIds.length; i++) {
            const values = this.columnIds[i].getValue();
            const linkValue = this.linkFunctions[i].call().trim();

            if (!linkValue) {
                values[index] = "";
            } else {
                values[index] = linkValue + linkPartSeparator + this.nameFunctions[i].call() + linkPartSeparator + this.targets[i];
            }

            this.columnIds[i].setValue(values);
        }
    },
    shouldUpdate: function (row) {
        const colIds = this.columnIds.flatMap(column => column.getId());
        return row.changes.some((element) => !colIds.includes(element));
    },
    checkIfOldParametersExist: function () {
        return this.get("href-link").length;
    },
    setWithFunctionParameters: function () {
        for (let i = 0; i < this.columnIds.length; i++) {
            const link = this.linkFunctions[i];
            const alias = this.nameFunctions[i];
            const target = this.targets[i];
            const valuesToSet = [];

            for (let j = 0; j < this.columnIds[i].getValue().length; j++) {
                this.setContextVariable("row-index", j);
                const linkValue = link.call().trim();
                if (!linkValue) {
                    valuesToSet.push("");
                } else {
                    valuesToSet.push(linkValue + linkPartSeparator + alias.call() + linkPartSeparator + target);
                }
            }

            this.columnIds[i].setValue(valuesToSet);
            VariableSetService.addRenderer(this.table, this.rendererHyperLink, [this.columnIds[i].getId()]);
        }
    },
    setWithOldParameters: function () {
        const tabHttp = this.get("href-link");
        const tabAlias = this.get("href-name");
        const tabHttpAlias = [];
        if (tabHttp.length !== 0) {
            for (let i = 0; i < tabHttp.length; i++) {
                const linkValue = tabHttp[i].trim();
                if (!linkValue) {
                    tabHttpAlias[i] = "";
                } else {
                    let tempString = linkValue + linkPartSeparator;
                    if (tabAlias != null && tabAlias[i] !== undefined && tabAlias[i] !== "") {
                        tempString += tabAlias[i];
                    } else {
                        tempString += linkValue;
                    }
                    tabHttpAlias[i] = tempString;
                }
            }

            this.get("column-id").setValue(tabHttpAlias);
        }
        VariableSetService.addRenderer(this.table, this.rendererHyperLink, [this.get("column-id").getId()]);
    },
    rendererHyperLink: function (value, data, column, metaData) {
        metaData.encode = false;
        if (value === undefined || value === "") {
            return "";
        }
        if (value.indexOf(linkPartSeparator) < 0) {
            return value;
        }
        const parts = value.split(linkPartSeparator);
        const href = parts[0];
        const alias = parts[1] ? parts[1] : parts[0];
        const target = parts[2] ? parts[2] : "_blank";

        if (href === "") {
            return value;
        }

        return "<a target='" + target + "' href='" + href + "' >" + alias + "</a>";
    }
});