/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.watermark.hooks;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.Files;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfReader;
import com.suncode.pdfutils.watermark.WatermarkImage;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.service.ConfigurationFileService;
import com.suncode.plugin.tools.pdfutils.PdfUtils;
import com.suncode.plugin.tools.watermark.dto.AddWatermarkConfigDto;
import com.suncode.plugin.tools.watermark.dto.ElementSizeDto;
import com.suncode.plugin.tools.watermark.dto.WatermarkDto;
import com.suncode.plugin.tools.watermark.enums.WatermarkPosition;
import com.suncode.plugin.tools.watermark.enums.WatermarkType;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.administration.user.UserInfo;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.hook.annotation.Hook;
import com.suncode.pwfl.util.annotation.Deprecated;
import com.suncode.pwfl.workflow.support.OpenedFileContext;
import com.suncode.pwfl.workflow.support.ReadFileHookAdapter;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@Hook
@Deprecated
public class AddWatermarkHook
extends ReadFileHookAdapter {
    private static final Logger log = LoggerFactory.getLogger(AddWatermarkHook.class);
    public static final String READABLE_FILE_ID = "add_watermark_hook_config";
    private static final ObjectMapper objectMapper = new ObjectMapper();
    @Autowired
    private PdfUtils pdfUtils;
    @Autowired
    private DocumentService documentService;
    @Autowired
    private ConfigurationFileService configurationFileService;
    @Autowired
    private Plugin plugin;

    public OpenedFileContext execute(OpenedFileContext fileContext) {
        List<AddWatermarkConfigDto> watermarkConfigList = this.readHookConfigurations();
        UserInfo user = UserContext.isActive() ? UserContext.current().getUser() : null;
        WfFile wfFile = fileContext.getWfFile();
        Long documentClassId = wfFile.getDocumentClass().getId();
        WfDocument document = this.documentService.getDocument(Long.valueOf(wfFile.getId()));
        List indexes = document.getIndexes();
        for (AddWatermarkConfigDto config : watermarkConfigList) {
            Assert.notNull((Object)config.getDocumentClassId(), (String)"Document class id cannot be null");
            WatermarkDto watermark = config.getWatermark();
            Assert.notNull((Object)((Object)watermark.getType()), (String)"Watermark type cannot be null");
            Assert.notNull((Object)watermark.getCodeHeight(), (String)"Barcode height cannot be null");
            Assert.notNull((Object)watermark.getCodeWidth(), (String)"Barcode width cannot be null");
            Assert.notNull((Object)((Object)watermark.getFormat()), (String)"Barcode format cannot be null");
            Assert.notNull((Object)watermark.getIndexId(), (String)"Index id cannot be null");
            Assert.notNull((Object)watermark.getMargin(), (String)"Margin cannot be null");
            Assert.notNull((Object)watermark.getOpacity(), (String)"Opacity cannot be null");
            Assert.notNull((Object)((Object)watermark.getPosition()), (String)"Watermark position cannot be null");
            if (watermark.getType() != WatermarkType.BARCODE) continue;
            boolean hasUserPermissions = this.isUserPermitted(user, config);
            boolean existsIndexId = indexes.stream().anyMatch(indexId -> indexId.getId().equals(watermark.getIndexId()));
            if (!hasUserPermissions || !existsIndexId || !documentClassId.equals(config.getDocumentClassId())) continue;
            Object indexValue = document.getIndexValue(watermark.getIndexId());
            if (indexValue instanceof String) {
                try {
                    this.addBarcodeToDocument(fileContext, config, (String)indexValue);
                }
                catch (Throwable ex) {
                    log.error("Error while adding barcode on document. Format: " + watermark.getFormat() + " code: " + indexValue, ex);
                }
                continue;
            }
            log.warn("Code " + indexValue + " is not a string. Ignoring");
        }
        return fileContext;
    }

    private boolean isUserPermitted(UserInfo user, AddWatermarkConfigDto config) {
        if (user == null || config.getPermissions() == null || config.getPermissions().getGroups() == null) {
            return true;
        }
        return config.getPermissions().getGroups().stream().anyMatch(groupName -> user.getGroups().stream().anyMatch(groupInfo -> groupInfo.getName().equals(groupName)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBarcodeToDocument(OpenedFileContext fileContext, AddWatermarkConfigDto addWatermarkConfigDto, String codeValue) throws Exception {
        if (StringUtils.isBlank((String)codeValue)) {
            return;
        }
        byte[] bytes = IOUtils.toByteArray((InputStream)fileContext.getInputStream());
        IOUtils.closeQuietly((InputStream)fileContext.getInputStream());
        try {
            WatermarkDto watermarkConfig = addWatermarkConfigDto.getWatermark();
            WfFile wfFile = fileContext.getWfFile();
            String barcodeImagePath = this.createBarcodeImage(codeValue, watermarkConfig.getFormat().getInternalFormat(), watermarkConfig.getCodeWidth(), watermarkConfig.getCodeHeight());
            try {
                log.debug("Temp barcode image has been created and is stored in: " + barcodeImagePath);
                ElementSizeDto pageSize = this.getPageSize(bytes, 1);
                ElementSizeDto barcodeSize = this.getBarcodeSize(barcodeImagePath);
                WatermarkImage watermarkBarcode = this.createWatermarkImage(watermarkConfig.getPosition(), pageSize, barcodeSize, barcodeImagePath, watermarkConfig.getMargin().floatValue(), watermarkConfig.getOpacity().floatValue());
                String fileName = wfFile.getFileName();
                String fileType = Files.getFileExtension((String)fileName);
                if (!fileType.equalsIgnoreCase("pdf")) {
                    log.debug("Document has a different format than pdf. Adding a barcode to the document has been aborted");
                    return;
                }
                InputStream barcodeStream = this.pdfUtils.addBarcode(fileName, new ByteArrayInputStream(bytes), watermarkBarcode);
                log.debug("Barcode image has been added to the PDF document");
                fileContext.setInputStream(barcodeStream);
            }
            finally {
                FileUtils.deleteQuietly((File)new File(barcodeImagePath));
                log.debug("Temp barcode file has been successfully removed from disk");
            }
        }
        catch (Throwable ex) {
            fileContext.setInputStream((InputStream)new ByteArrayInputStream(bytes));
            throw ex;
        }
    }

    private List<AddWatermarkConfigDto> readHookConfigurations() throws IOException {
        try (InputStream in = this.configurationFileService.readFile(this.plugin.getKey(), READABLE_FILE_ID);){
            String hookConfigurations = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            if (StringUtils.isBlank((String)hookConfigurations)) {
                ArrayList<AddWatermarkConfigDto> arrayList = new ArrayList<AddWatermarkConfigDto>();
                return arrayList;
            }
            List list = (List)objectMapper.readValue(hookConfigurations, (TypeReference)new TypeReference<List<AddWatermarkConfigDto>>(){});
            return list;
        }
    }

    private String createBarcodeImage(String code, BarcodeFormat format, int sizeX, int sizeY) throws WriterException, IOException {
        MultiFormatWriter barcodeWriter = new MultiFormatWriter();
        BitMatrix barcodeBitMatrix = barcodeWriter.encode(code, format, sizeX, sizeY);
        String homePath = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.WORKING_DIRECTORY);
        Path barcodePath = Paths.get(homePath, UUID.randomUUID().toString() + ".png");
        MatrixToImageWriter.writeToPath((BitMatrix)barcodeBitMatrix, (String)"png", (Path)barcodePath);
        return barcodePath.toFile().getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ElementSizeDto getPageSize(byte[] bytes, int pageNumber) throws IOException {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(bytes);){
            ElementSizeDto elementSizeDto;
            PdfReader reader = new PdfReader((InputStream)stream);
            try {
                Rectangle pageSize = reader.getPageSize(pageNumber);
                elementSizeDto = new ElementSizeDto(pageSize.getWidth(), pageSize.getHeight());
            }
            catch (Throwable throwable) {
                reader.close();
                throw throwable;
            }
            reader.close();
            return elementSizeDto;
        }
    }

    private ElementSizeDto getBarcodeSize(String barcodeImagePath) throws IOException {
        BufferedImage barcodeImage = ImageIO.read(new File(barcodeImagePath));
        return new ElementSizeDto(barcodeImage.getWidth(), barcodeImage.getHeight());
    }

    private WatermarkImage createWatermarkImage(WatermarkPosition watermarkPosition, ElementSizeDto pageSize, ElementSizeDto barcodeSize, String barcodeImagePath, float margin, float opacity) {
        WatermarkImage watermarkBarcodeImage = new WatermarkImage(barcodeImagePath);
        watermarkBarcodeImage.setOpacity(Float.valueOf(opacity));
        watermarkBarcodeImage.setPositionX(Float.valueOf(this.calcPositionX(watermarkPosition, pageSize.getWidth(), barcodeSize.getWidth(), margin)));
        watermarkBarcodeImage.setPositionY(Float.valueOf(this.calcPositionY(watermarkPosition, pageSize.getHeight(), barcodeSize.getHeight(), margin)));
        return watermarkBarcodeImage;
    }

    private float calcPositionX(WatermarkPosition watermarkPosition, float pageWidth, float imageWidth, float margin) {
        switch (watermarkPosition) {
            case TOP_LEFT: 
            case LEFT: 
            case BOTTOM_LEFT: {
                return margin;
            }
            case TOP: 
            case CENTER: 
            case BOTTOM: {
                return pageWidth / 2.0f - imageWidth / 2.0f;
            }
            case TOP_RIGHT: 
            case RIGHT: 
            case BOTTOM_RIGHT: {
                return pageWidth - imageWidth - margin;
            }
        }
        throw new RuntimeException("Wrong watermark position");
    }

    private float calcPositionY(WatermarkPosition watermarkPosition, float pageHeight, float imageHeight, float margin) {
        switch (watermarkPosition) {
            case TOP_LEFT: 
            case TOP: 
            case TOP_RIGHT: {
                return pageHeight - imageHeight - margin;
            }
            case LEFT: 
            case CENTER: 
            case RIGHT: {
                return pageHeight / 2.0f - imageHeight / 2.0f;
            }
            case BOTTOM_LEFT: 
            case BOTTOM: 
            case BOTTOM_RIGHT: {
                return margin;
            }
        }
        throw new RuntimeException("Wrong watermark position");
    }
}

