/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.servlet;

import com.suncode.plugin.tools.pdfutils.BarcodeType;
import com.suncode.pwfl.search.CountedResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/pdf"})
public class PdfController {
    @RequestMapping(value={"barcodeFormats"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<Map<String, Object>> getBarcodeFormats(@RequestParam String query, @RequestParam String start, @RequestParam String limit) {
        CountedResult result = new CountedResult();
        ArrayList<Map> barcodeTypes = new ArrayList<Map>();
        ArrayList tempBarcodeTypes = new ArrayList();
        for (BarcodeType barcodeFormat : BarcodeType.values()) {
            HashMap<String, String> tempMap = new HashMap<String, String>();
            tempMap.put("name", barcodeFormat.name());
            tempBarcodeTypes.add(tempMap);
        }
        if (StringUtils.isBlank((CharSequence)query)) {
            barcodeTypes = tempBarcodeTypes;
        } else {
            for (Map map : tempBarcodeTypes) {
                if (!map.get("name").toString().toLowerCase().contains(query.toLowerCase())) continue;
                barcodeTypes.add(map);
            }
        }
        Collections.sort(barcodeTypes, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> m1, Map<String, Object> m2) {
                return m1.get("name").toString().compareTo(m2.get("name").toString());
            }
        });
        int totalResult = barcodeTypes.size();
        Long l = Long.valueOf(start);
        Long limitL = Long.valueOf(limit);
        if (totalResult > limitL.intValue()) {
            result.setData(barcodeTypes.subList(l.intValue(), l.intValue() + limitL.intValue()));
        } else {
            result.setData(barcodeTypes);
        }
        result.setTotal((long)totalResult);
        return result;
    }
}

