/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.servlet;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.support.hibernate.type.StandardBasicTypes;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.process.Process;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.Shark;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class GetLastExecutorTaskController {
    private static final Logger log = LoggerFactory.getLogger(GetLastExecutorTaskController.class);
    private static final String ORACLE_DRIVER = "oracle.jdbc.driver.OracleDriver";
    private static final String POSTGRESQL_DRIVER = "org.postgresql.Driver";
    private static final String SQLSERVER_DRIVER = "com.microsoft.sqlserver.jdbc.SQLServerDriver";

    @RequestMapping(value={"/executor/getlogin"}, method={RequestMethod.GET})
    @ResponseBody
    public String getExecutorLogin(@RequestParam(value="task") String taskId, @RequestParam(value="varParamJson") String varParamsJson, @RequestParam(value="processId") String processId) {
        Process process = ServiceFactory.getProcessService().getProcess(processId, new String[]{"processDefinition"});
        String processDefId = process.getProcessDefinition().getProcessDefinitionId();
        Type type = new TypeToken<Map<String, Object>>(){}.getType();
        Map hmSearchMap = (Map)new Gson().fromJson(varParamsJson, type);
        return this.getTaskExecutor(processDefId, taskId, hmSearchMap, "laststatetime");
    }

    private String getTaskExecutor(String processDefId, String activityName, Map<String, Object> hmSearchMap, String orderBy) {
        log.debug("getTaskExecutor processDefId:" + processDefId + ",activityName:" + activityName + ",hmSearchMap:" + hmSearchMap.toString());
        String driver = Shark.getInstance().getProperties().getProperty("DatabaseManager.DB.sharkdb.JdbcDriver");
        String result = "";
        StringBuilder query = new StringBuilder();
        if (driver.equals(ORACLE_DRIVER)) {
            query.append("SELECT * FROM (");
        } else if (driver.equals(SQLSERVER_DRIVER)) {
            query.append("SELECT * FROM (");
        }
        query.append(MessageFormat.format("SELECT DISTINCT pmidx.processid, resourceId, laststatetime FROM pm_idx_{0} pmidx JOIN activities a ON a.processid = pmidx.processid WHERE a.activitydefinitionid = :activityDefId AND a.state=1000007 AND resourceId IS NOT NULL ", processDefId));
        Object iterator = hmSearchMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> parameter = iterator.next();
            if (driver.equals(ORACLE_DRIVER) && this.isNullOrEmpty(parameter.getValue())) {
                query.append(MessageFormat.format(" AND {0} IS NULL", parameter.getKey()));
                iterator.remove();
                continue;
            }
            query.append(MessageFormat.format(" AND {0} = :{1}", parameter.getKey(), parameter.getKey()));
        }
        switch (driver) {
            case "org.postgresql.Driver": {
                query.append(MessageFormat.format(" ORDER BY {0} DESC LIMIT 10", orderBy));
                break;
            }
            case "oracle.jdbc.driver.OracleDriver": {
                query.append(MessageFormat.format(" ORDER BY {0} DESC) WHERE ROWNUM <= 10", orderBy));
                break;
            }
            case "com.microsoft.sqlserver.jdbc.SQLServerDriver": {
                query.append(MessageFormat.format(") AS alias ORDER BY {0} DESC OFFSET 0 ROWS FETCH NEXT 10 ROWS ONLY", orderBy));
                break;
            }
            default: {
                query.append(MessageFormat.format(" ORDER BY {0} DESC", orderBy));
            }
        }
        SQLBuilder sqlBuilder = new SQLBuilder(query.toString());
        sqlBuilder.setParameter("activityDefId", (Object)activityName);
        sqlBuilder.addScalar("resourceId", StandardBasicTypes.STRING);
        for (Map.Entry<String, Object> entry : hmSearchMap.entrySet()) {
            sqlBuilder.setParameter(entry.getKey(), entry.getValue());
        }
        SQLFinder finder = FinderFactory.getSQLFinder();
        log.debug(sqlBuilder.buildQuery());
        List data = finder.find(sqlBuilder);
        if (data != null && data.size() > 0) {
            for (Map map : data) {
                String resourceId = (String)map.get("resourceId");
                if (ServiceFactory.getUserService().getUser(resourceId, new String[0]) == null) continue;
                result = resourceId;
                break;
            }
        }
        log.debug("getTaskExecutor resourceId:" + result);
        return result;
    }

    private boolean isNullOrEmpty(Object value) {
        return value == null || value instanceof String && StringUtils.isEmpty((CharSequence)((String)value));
    }
}

