/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.service;

import com.suncode.plugin.tools.service.ConvertNumberToWordService;
import com.suncode.plugin.tools.until.MoneyConverterUtils;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLEncoder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import pl.allegro.finance.tradukisto.MoneyConverters;

@Service
public class ConvertNumberToWordImpl
implements ConvertNumberToWordService {
    @Override
    public String convert(Double number, String language, String currencySymbol) throws UnsupportedEncodingException {
        BigDecimal numberToConvert = BigDecimal.valueOf(number).setScale(2, RoundingMode.HALF_UP).abs();
        MoneyConverters converter = MoneyConverterUtils.getConverterLanguage(language);
        StringBuilder result = new StringBuilder();
        if (number < 0.0) {
            result.append(MoneyConverterUtils.getNegativeTranslation(language)).append(" ");
        }
        if (StringUtils.isNotBlank((CharSequence)currencySymbol)) {
            result.append(converter.asWords(numberToConvert, currencySymbol));
        } else {
            result.append(converter.asWords(numberToConvert));
        }
        return URLEncoder.encode(StringUtils.capitalize((String)result.toString()), "UTF-8");
    }
}

